/*
 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */

//DateRanges declaration start
function DateRanges(dateRangesArray,
                    styleClassName,
                    rolloverStyleClassName,
                    disableExcluded,
                    disableIncluded,
                    selectedDayClassName,
                    rolloverSelectedDayClassName) {
  this._dateRanges = dateRangesArray;
  this._styleClassName = styleClassName;
  this._rolloverStyleClassName = rolloverStyleClassName;
  this._disableExcluded = disableExcluded;
  this._disableIncluded = disableIncluded;
  this._selectedDayClassName = selectedDayClassName;
  this._rolloverSelectedDayClassName = rolloverSelectedDayClassName;
}

DateRanges.prototype.getDateRanges = function() {
  return this._dateRanges;
}

DateRanges.prototype.getSimpleDateRanges = function() {
  if (!this._dateRanges) return undefined;
  var simpleDateRanges = new Array;
  for (var i = 0; i < this._dateRanges.length; i ++) {
    var dateRange = this._dateRanges[i];
    if (dateRange instanceof SimpleDateRange) {
      simpleDateRanges[simpleDateRanges.length] = dateRange;
    }
  }
  return simpleDateRanges;
}
//DateRanges declaration end

//---------------------------------------------------------------

//AbstractDateRange declaration start
function AbstractDateRange(styleClassName, rolloverStyleClassName,
                           selectedDayStyleClassName, rolloverSelectedDayStyleClassName) {
  this._dates = new Array;
  this._styleClassName = styleClassName;
  this._rolloverStyleClassName = rolloverStyleClassName;
  this._selectedDayStyleClassName = selectedDayStyleClassName;
  this._rolloverSelectedDayStyleClassName = rolloverSelectedDayStyleClassName;
}

AbstractDateRange.prototype.getDates = function() {
  return this._dates;
}
//AbstractDateRange declaration end

//---------------------------------------------------------------

//SimpleDateRange object declaration start
function SimpleDateRange(fromDate, toDate, styleClassName, rolloverStyleClassName,
                         selectedDayStyleClassName, rolloverSelectedDayStyleClassName) {
  this._fromDate = fromDate;
  this._toDate = toDate;
  AbstractDateRange.apply(this, [styleClassName, rolloverStyleClassName, selectedDayStyleClassName,
          rolloverSelectedDayStyleClassName]);
}
SimpleDateRange.prototype = new AbstractDateRange;

SimpleDateRange.prototype.isDateInRange = function(date) {
  if (!date) return false;
  if (q__calendar_compareDates(date, this._fromDate) >= 0 && q__calendar_compareDates(date, this._toDate) <= 0) return true;
  return false;
}
//SimpleDateRange object declaration end