/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.dom.Property;
import com.steadystate.css.parser.CSSOMParser;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSStyleDeclarationImpl
implements CSSStyleDeclaration,
Serializable {
    private CSSRule _parentRule;
    private Vector _properties = new Vector();

    public CSSStyleDeclarationImpl(CSSRule cSSRule) {
        this._parentRule = cSSRule;
    }

    public String getCssText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n = 0;
        while (n < this._properties.size()) {
            Property property = (Property)this._properties.elementAt(n);
            if (property != null) {
                stringBuffer.append(property.toString());
            }
            if (n < this._properties.size() - 1) {
                stringBuffer.append("; ");
            }
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void setCssText(String string) throws DOMException {
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            this._properties.removeAllElements();
            cSSOMParser.parseStyleDeclaration(this, inputSource);
        }
        catch (Exception exception) {
            throw new DOMExceptionImpl(12, 0, exception.getMessage());
        }
    }

    public String getPropertyValue(String string) {
        Property property = this.getPropertyDeclaration(string);
        return property != null ? property.getValue().toString() : "";
    }

    public CSSValue getPropertyCSSValue(String string) {
        Property property = this.getPropertyDeclaration(string);
        return property != null ? property.getValue() : null;
    }

    public String removeProperty(String string) throws DOMException {
        int n = 0;
        while (n < this._properties.size()) {
            Property property = (Property)this._properties.elementAt(n);
            if (property.getName().equalsIgnoreCase(string)) {
                this._properties.removeElementAt(n);
                return property.getValue().toString();
            }
            ++n;
        }
        return "";
    }

    public String getPropertyPriority(String string) {
        Property property = this.getPropertyDeclaration(string);
        if (property != null) {
            return property.isImportant() ? "important" : "";
        }
        return "";
    }

    public void setProperty(String string, String string2, String string3) throws DOMException {
        try {
            boolean bl;
            InputSource inputSource = new InputSource(new StringReader(string2));
            CSSOMParser cSSOMParser = new CSSOMParser();
            CSSValue cSSValue = cSSOMParser.parsePropertyValue(inputSource);
            Property property = this.getPropertyDeclaration(string);
            boolean bl2 = bl = string3 != null ? string3.equalsIgnoreCase("important") : false;
            if (property == null) {
                property = new Property(string, cSSValue, bl);
                this.addProperty(property);
            } else {
                property.setValue(cSSValue);
                property.setImportant(bl);
            }
        }
        catch (Exception exception) {
            throw new DOMExceptionImpl(12, 0, exception.getMessage());
        }
    }

    public int getLength() {
        return this._properties.size();
    }

    public String item(int n) {
        Property property = (Property)this._properties.elementAt(n);
        return property != null ? property.getName() : "";
    }

    public CSSRule getParentRule() {
        return this._parentRule;
    }

    public void addProperty(Property property) {
        this._properties.addElement(property);
    }

    private Property getPropertyDeclaration(String string) {
        int n = 0;
        while (n < this._properties.size()) {
            Property property = (Property)this._properties.elementAt(n);
            if (property.getName().equalsIgnoreCase(string)) {
                return property;
            }
            ++n;
        }
        return null;
    }

    public String toString() {
        return this.getCssText();
    }
}

