/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jsf.component.chart.impl.jfc.helpers;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Date;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.time.TimeSeriesCollection;
import teamdev.jsf.component.chart.Chart;
import teamdev.jsf.component.chart.ChartModel;
import teamdev.jsf.component.chart.impl.jfc.ModelConverter;
import teamdev.jsf.component.chart.impl.jfc.ModelInfo;
import teamdev.jsf.component.chart.impl.jfc.ModelType;
import teamdev.jsf.component.chart.impl.view.GridPointInfoImpl;
import teamdev.jsf.component.chart.impl.view.PieSectorInfoImpl;
import teamdev.jsf.component.chart.impl.view.SeriesInfoImpl;
import teamdev.jsf.component.chart.view.GridPointInfo;
import teamdev.jsf.component.chart.view.PieSectorInfo;

public class ChartInfoUtil {
    public static GridPointInfo getGridPointInfo(ChartEntity chartEntity, Chart chart) {
        if (chartEntity instanceof CategoryItemEntity) {
            return ChartInfoUtil.getGridPointInfo((CategoryItemEntity)chartEntity, chart);
        }
        if (chartEntity instanceof XYItemEntity) {
            return ChartInfoUtil.getGridPointInfo((XYItemEntity)chartEntity, chart);
        }
        return null;
    }

    public static PieSectorInfo getPieSectorInfo(ChartEntity chartEntity, Chart chart) {
        if (chartEntity instanceof PieSectionEntity) {
            PieSectionEntity pieSectionEntity = (PieSectionEntity)chartEntity;
            return ChartInfoUtil.getPieSectorInfo(pieSectionEntity.getDataset(), pieSectionEntity.getSectionKey(), pieSectionEntity.getPieIndex(), pieSectionEntity);
        }
        return null;
    }

    public static PieSectorInfo getPieSectorInfo(PieDataset pieDataset, Comparable comparable, int n2, PieSectionEntity pieSectionEntity) {
        Object object;
        int n3;
        double d2 = 0.0;
        for (n3 = 0; n3 < pieDataset.getKeys().size(); ++n3) {
            double d3;
            object = pieDataset.getKeys().get(n3);
            Number number = pieDataset.getValue((Comparable)object);
            if (number == null) continue;
            double d4 = number.doubleValue();
            if (!(d3 > 0.0)) continue;
            d2 += d4;
        }
        n3 = pieDataset.getIndex(comparable);
        object = pieDataset.getValue(n3);
        double d5 = 0.0;
        if (object != null) {
            d5 = ((Number)object).doubleValue();
        }
        PieSectorInfoImpl pieSectorInfoImpl = new PieSectorInfoImpl();
        pieSectorInfoImpl.setKey(comparable);
        pieSectorInfoImpl.setValue(object);
        pieSectorInfoImpl.setSeriesTotal(new Double(d2));
        pieSectorInfoImpl.setIndex(n3);
        pieSectorInfoImpl.setSeries(new SeriesInfoImpl());
        pieSectorInfoImpl.getSeries().setIndex(n2);
        double d6 = 0.0;
        String string = null;
        d6 = d5 / d2;
        DecimalFormat decimalFormat = new DecimalFormat("#.00%");
        string = decimalFormat.format(d6);
        pieSectorInfoImpl.setProportionalValue(string);
        return pieSectorInfoImpl;
    }

    public static GridPointInfo getGridPointInfo(CategoryItemEntity categoryItemEntity, Chart chart) {
        ChartModel chartModel = chart.getModel();
        if (chartModel == null) {
            return null;
        }
        GridPointInfoImpl gridPointInfoImpl = new GridPointInfoImpl();
        gridPointInfoImpl.setSeries(new SeriesInfoImpl());
        gridPointInfoImpl.getSeries().setIndex(categoryItemEntity.getSeries());
        ModelInfo modelInfo = new ModelInfo(chartModel);
        if (!modelInfo.isEmptyData()) {
            CategoryDataset categoryDataset = ModelConverter.toCategoryDataset(chartModel, modelInfo);
            Comparable comparable = categoryDataset.getRowKey(categoryItemEntity.getSeries());
            Comparable comparable2 = categoryDataset.getColumnKey(categoryItemEntity.getCategoryIndex());
            Number number = categoryDataset.getValue(comparable, comparable2);
            gridPointInfoImpl.setKey(comparable2);
            gridPointInfoImpl.setValue(number);
            gridPointInfoImpl.getSeries().setKey(comparable);
        }
        return gridPointInfoImpl;
    }

    public static GridPointInfo getGridPointInfo(XYItemEntity xYItemEntity, Chart chart) {
        ChartModel chartModel = chart.getModel();
        if (chartModel == null) {
            return null;
        }
        GridPointInfoImpl gridPointInfoImpl = new GridPointInfoImpl();
        gridPointInfoImpl.setSeries(new SeriesInfoImpl());
        gridPointInfoImpl.getSeries().setIndex(xYItemEntity.getSeriesIndex());
        ModelInfo modelInfo = new ModelInfo(chartModel);
        if (!modelInfo.isEmptyData()) {
            Number number;
            Number number2;
            Comparable comparable;
            TimeSeriesCollection timeSeriesCollection;
            if (modelInfo.getModelType() == ModelType.Date) {
                Serializable serializable;
                GridPointInfoImpl gridPointInfoImpl2;
                timeSeriesCollection = ModelConverter.toTimeSeriesCollection(chartModel, modelInfo);
                comparable = timeSeriesCollection.getSeriesKey(xYItemEntity.getSeriesIndex());
                number2 = timeSeriesCollection.getX(xYItemEntity.getSeriesIndex(), xYItemEntity.getItem());
                if (number2 instanceof Long) {
                    gridPointInfoImpl2 = gridPointInfoImpl;
                    serializable = new Date(number2.longValue());
                } else {
                    gridPointInfoImpl2 = gridPointInfoImpl;
                    serializable = number2;
                }
                gridPointInfoImpl2.setKey(serializable);
                number = timeSeriesCollection.getY(xYItemEntity.getSeriesIndex(), xYItemEntity.getItem());
            } else {
                timeSeriesCollection = ModelConverter.toXYSeriesCollection(chartModel, modelInfo);
                comparable = timeSeriesCollection.getSeriesKey(xYItemEntity.getSeriesIndex());
                number2 = timeSeriesCollection.getX(xYItemEntity.getSeriesIndex(), xYItemEntity.getItem());
                gridPointInfoImpl.setKey(number2);
                number = timeSeriesCollection.getY(xYItemEntity.getSeriesIndex(), xYItemEntity.getItem());
            }
            Number number3 = number;
            gridPointInfoImpl.setValue(number3);
            gridPointInfoImpl.getSeries().setKey(comparable);
        }
        return gridPointInfoImpl;
    }
}

