/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jsf.component.chart.impl.jfc;

import java.util.Calendar;
import java.util.Date;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import teamdev.jsf.component.chart.ChartModel;
import teamdev.jsf.component.chart.Series;
import teamdev.jsf.component.chart.Tuple;
import teamdev.jsf.component.chart.impl.jfc.DataConversionException;
import teamdev.jsf.component.chart.impl.jfc.ModelInfo;

public class ModelConverter {
    public static PieDataset toPieDataset(ChartModel chartModel) {
        ModelInfo modelInfo = new ModelInfo(chartModel);
        if (modelInfo.isEmptyData()) {
            return null;
        }
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        Series[] seriesArray = modelInfo.getNotEmptySeriesList();
        for (int i2 = 0; i2 < seriesArray.length; ++i2) {
            Tuple[] tupleArray = seriesArray[i2].getTuples();
            if (tupleArray == null) continue;
            for (int i3 = 0; i3 < tupleArray.length; ++i3) {
                Object object;
                Comparable comparable;
                Comparable comparable2 = comparable = tupleArray[i3].getKey();
                if (comparable instanceof Calendar) {
                    comparable2 = ((Calendar)comparable).getTime();
                }
                if (!((object = tupleArray[i3].getValue()) instanceof Number)) {
                    throw new DataConversionException("Incorrect Value type. Required: Number. Currently defined: " + object.getClass());
                }
                defaultPieDataset.setValue(comparable2, (Number)object);
            }
        }
        if (defaultPieDataset.getItemCount() == 0) {
            defaultPieDataset = null;
        }
        return defaultPieDataset;
    }

    public static CategoryDataset toCategoryDataset(ChartModel chartModel, ModelInfo modelInfo) {
        if (modelInfo.isEmptyData()) {
            return null;
        }
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        Series[] seriesArray = modelInfo.getNotEmptySeriesList();
        for (int i2 = 0; i2 < seriesArray.length; ++i2) {
            Tuple[] tupleArray = seriesArray[i2].getTuples();
            for (int i3 = 0; i3 < tupleArray.length; ++i3) {
                Comparable comparable = tupleArray[i3].getKey();
                Object object = tupleArray[i3].getValue();
                if (!(object instanceof Number)) {
                    throw new DataConversionException("Incorrect Value type for Key = " + comparable + ". Required: Number. Currently defined: " + object.getClass());
                }
                defaultCategoryDataset.addValue((Number)object, seriesArray[i2].getId(), tupleArray[i3].getKey());
            }
        }
        if (defaultCategoryDataset.getRowCount() == 0) {
            defaultCategoryDataset = null;
        }
        return defaultCategoryDataset;
    }

    private static XYSeries a(Series series) {
        if (series == null) {
            return null;
        }
        if (series.getTuples() == null) {
            return null;
        }
        XYSeries xYSeries = null;
        xYSeries = new XYSeries(series.getId());
        Tuple[] tupleArray = series.getTuples();
        for (int i2 = 0; i2 < tupleArray.length; ++i2) {
            Tuple tuple = tupleArray[i2];
            Comparable comparable = tuple.getKey();
            Object object = tuple.getValue();
            if (comparable instanceof Number) {
                if (!(object instanceof Number)) {
                    throw new DataConversionException("Incorrect Value type. Required: Number. Currently defined: " + object.getClass());
                }
            } else {
                throw new DataConversionException("Incorrect Value type for Key = " + comparable + ". Required: Number. Currently defined: " + comparable.getClass());
            }
            xYSeries.add((Number)((Object)comparable), (Number)object);
        }
        if (xYSeries.getItemCount() == 0) {
            xYSeries = null;
        }
        return xYSeries;
    }

    private static TimeSeries b(Series series) {
        if (series == null) {
            return null;
        }
        if (series.getTuples() == null) {
            return null;
        }
        TimeSeries timeSeries = null;
        timeSeries = new TimeSeries(series.getId().toString());
        Tuple[] tupleArray = series.getTuples();
        for (int i2 = 0; i2 < tupleArray.length; ++i2) {
            Day day;
            Tuple tuple = tupleArray[i2];
            Comparable comparable = tuple.getKey();
            Object object = tuple.getValue();
            if (comparable instanceof Date) {
                day = new Day((Date)comparable);
            } else if (comparable instanceof Calendar) {
                day = new Day(((Calendar)comparable).getTime());
            } else {
                throw new DataConversionException("Incorrect Key type. Required: Date or Calendar. Currently defined: " + comparable.getClass());
            }
            if (!(object instanceof Number)) {
                throw new DataConversionException("Incorrect Value type for Key = " + comparable + ". Required: Number. Currently defined: " + object.getClass());
            }
            TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem((RegularTimePeriod)day, (Number)object);
            timeSeries.add(timeSeriesDataItem);
        }
        if (timeSeries.getItemCount() == 0) {
            timeSeries = null;
        }
        return timeSeries;
    }

    public static XYSeriesCollection toXYSeriesCollection(ChartModel chartModel, ModelInfo modelInfo) {
        if (modelInfo.isEmptyData()) {
            return null;
        }
        XYSeriesCollection xYSeriesCollection = null;
        xYSeriesCollection = new XYSeriesCollection();
        Series[] seriesArray = modelInfo.getNotEmptySeriesList();
        for (int i2 = 0; i2 < seriesArray.length; ++i2) {
            XYSeries xYSeries = ModelConverter.a(seriesArray[i2]);
            if (xYSeries == null) continue;
            xYSeriesCollection.addSeries(xYSeries);
        }
        return xYSeriesCollection;
    }

    public static TimeSeriesCollection toTimeSeriesCollection(ChartModel chartModel, ModelInfo modelInfo) {
        if (modelInfo.isEmptyData()) {
            return null;
        }
        TimeSeriesCollection timeSeriesCollection = null;
        timeSeriesCollection = new TimeSeriesCollection();
        Series[] seriesArray = modelInfo.getNotEmptySeriesList();
        for (int i2 = 0; i2 < seriesArray.length; ++i2) {
            TimeSeries timeSeries = ModelConverter.b(seriesArray[i2]);
            if (timeSeries == null) continue;
            timeSeriesCollection.addSeries(timeSeries);
        }
        return timeSeriesCollection;
    }
}

