/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jsf.component.chart;

import java.io.Serializable;
import teamdev.jsf.component.chart.impl.view.BarChartView;
import teamdev.jsf.component.chart.impl.view.LineChartView;
import teamdev.jsf.component.chart.impl.view.PieChartView;
import teamdev.jsf.component.chart.view.ChartView;

public class ChartViewType
implements Serializable {
    public static final ChartViewType PIE = new ChartViewType("pie");
    public static final ChartViewType BAR = new ChartViewType("bar");
    public static final ChartViewType LINE = new ChartViewType("line");
    private final String a;

    public static ChartViewType fromString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("chartViewStr shouldn't be null");
        }
        if (ChartViewType.PIE.a.equals(string)) {
            return PIE;
        }
        if (ChartViewType.BAR.a.equals(string)) {
            return BAR;
        }
        if (ChartViewType.LINE.a.equals(string)) {
            return LINE;
        }
        throw new IllegalArgumentException("Invalid chart view specification: \"" + string + "\". One of the following values should be specified: \"pie\", \"bar\", or \"line\".");
    }

    private ChartViewType(String string) {
        this.a = string;
    }

    public ChartView createChartView() {
        if (ChartViewType.PIE.a.equals(this.a)) {
            return new PieChartView();
        }
        if (ChartViewType.BAR.a.equals(this.a)) {
            return new BarChartView();
        }
        if (ChartViewType.LINE.a.equals(this.a)) {
            return new LineChartView();
        }
        throw new IllegalStateException("Unknown ChartViewType enumeration value: " + this.a);
    }

    public String toString() {
        return this.a;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ChartViewType chartViewType = (ChartViewType)object;
        return this.a.equals(chartViewType.a);
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    public boolean isViewOfThisType(ChartView chartView) {
        if (ChartViewType.PIE.a.equals(this.a)) {
            return chartView instanceof PieChartView;
        }
        if (ChartViewType.BAR.a.equals(this.a)) {
            return chartView instanceof BarChartView;
        }
        if (ChartViewType.LINE.a.equals(this.a)) {
            return chartView instanceof LineChartView;
        }
        throw new IllegalStateException("Unknown ChartViewType enumeration value: " + this.a);
    }
}

