/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.general.SeriesException;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;

public class XYSeriesTests
extends TestCase {
    private static final double EPSILON = 1.0E-10;

    public static Test suite() {
        return new TestSuite(XYSeriesTests.class);
    }

    public XYSeriesTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYSeries s1 = new XYSeries((Comparable)((Object)"Series"));
        s1.add(1.0, 1.1);
        XYSeries s2 = new XYSeries((Comparable)((Object)"Series"));
        s2.add(1.0, 1.1);
        XYSeriesTests.assertTrue((boolean)s1.equals(s2));
        XYSeriesTests.assertTrue((boolean)s2.equals(s1));
        s1.setKey((Comparable)((Object)"Series X"));
        XYSeriesTests.assertFalse((boolean)s1.equals(s2));
        s2.setKey((Comparable)((Object)"Series X"));
        XYSeriesTests.assertTrue((boolean)s1.equals(s2));
    }

    public void testCloning() {
        XYSeries s1 = new XYSeries((Comparable)((Object)"Series"));
        s1.add(1.0, 1.1);
        XYSeries s2 = null;
        try {
            s2 = (XYSeries)s1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("XYSeriesTests.testCloning: failed to clone.");
        }
        XYSeriesTests.assertTrue((s1 != s2 ? 1 : 0) != 0);
        XYSeriesTests.assertTrue((s1.getClass() == s2.getClass() ? 1 : 0) != 0);
        XYSeriesTests.assertTrue((boolean)s1.equals(s2));
    }

    public void testSerialization() {
        XYSeries s1 = new XYSeries((Comparable)((Object)"Series"));
        s1.add(1.0, 1.1);
        XYSeries s2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(s1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            s2 = (XYSeries)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        XYSeriesTests.assertEquals((Object)s1, s2);
    }

    public void testIndexOf() {
        XYSeries s1 = new XYSeries((Comparable)((Object)"Series 1"));
        s1.add(1.0, 1.0);
        s1.add(2.0, 2.0);
        s1.add(3.0, 3.0);
        XYSeriesTests.assertEquals((int)0, (int)s1.indexOf(new Double(1.0)));
    }

    public void testIndexOf2() {
        XYSeries s1 = new XYSeries((Comparable)((Object)"Series 1"), false, true);
        s1.add(1.0, 1.0);
        s1.add(3.0, 3.0);
        s1.add(2.0, 2.0);
        XYSeriesTests.assertEquals((int)0, (int)s1.indexOf(new Double(1.0)));
        XYSeriesTests.assertEquals((int)1, (int)s1.indexOf(new Double(3.0)));
        XYSeriesTests.assertEquals((int)2, (int)s1.indexOf(new Double(2.0)));
    }

    public void testRemove() {
        XYSeries s1 = new XYSeries((Comparable)((Object)"Series 1"));
        s1.add(1.0, 1.0);
        s1.add(2.0, 2.0);
        s1.add(3.0, 3.0);
        XYSeriesTests.assertEquals((int)3, (int)s1.getItemCount());
        s1.remove(new Double(2.0));
        XYSeriesTests.assertEquals((Object)new Double(3.0), (Object)s1.getX(1));
        s1.remove(0);
        XYSeriesTests.assertEquals((Object)new Double(3.0), (Object)s1.getX(0));
    }

    public void testAdditionOfDuplicateXValues() {
        XYSeries s1 = new XYSeries((Comparable)((Object)"Series 1"));
        s1.add(1.0, 1.0);
        s1.add(2.0, 2.0);
        s1.add(2.0, 3.0);
        s1.add(2.0, 4.0);
        s1.add(3.0, 5.0);
        XYSeriesTests.assertEquals((double)1.0, (double)s1.getY(0).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)2.0, (double)s1.getY(1).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)3.0, (double)s1.getY(2).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)4.0, (double)s1.getY(3).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)5.0, (double)s1.getY(4).doubleValue(), (double)1.0E-10);
    }

    public void testUpdate() {
        XYSeries series = new XYSeries((Comparable)((Object)"S1"));
        series.add(new Integer(1), (Number)new Integer(2));
        XYSeriesTests.assertEquals((Object)new Integer(2), (Object)series.getY(0));
        series.update(new Integer(1), (Number)new Integer(3));
        XYSeriesTests.assertEquals((Object)new Integer(3), (Object)series.getY(0));
        try {
            series.update(new Integer(2), (Number)new Integer(99));
            XYSeriesTests.assertTrue((boolean)false);
        }
        catch (SeriesException seriesException) {
            // empty catch block
        }
    }

    public void testUpdate2() {
        XYSeries series = new XYSeries((Comparable)((Object)"Series"), false, true);
        series.add(5.0, 55.0);
        series.add(4.0, 44.0);
        series.add(6.0, 66.0);
        series.update(new Double(4.0), (Number)new Double(99.0));
        XYSeriesTests.assertEquals((Object)new Double(99.0), (Object)series.getY(1));
    }

    public void testAddOrUpdate() {
        XYSeries series = new XYSeries((Comparable)((Object)"S1"));
        XYDataItem old = series.addOrUpdate(new Long(1L), new Long(2L));
        XYSeriesTests.assertTrue((old == null ? 1 : 0) != 0);
        XYSeriesTests.assertEquals((int)1, (int)series.getItemCount());
        XYSeriesTests.assertEquals((Object)new Long(2L), (Object)series.getY(0));
        old = series.addOrUpdate(new Long(2L), new Long(3L));
        XYSeriesTests.assertTrue((old == null ? 1 : 0) != 0);
        XYSeriesTests.assertEquals((int)2, (int)series.getItemCount());
        XYSeriesTests.assertEquals((Object)new Long(3L), (Object)series.getY(1));
        old = series.addOrUpdate(new Long(1L), new Long(99L));
        XYSeriesTests.assertEquals((Object)new XYDataItem(new Long(1L), new Long(2L)), (Object)old);
        XYSeriesTests.assertEquals((int)2, (int)series.getItemCount());
        XYSeriesTests.assertEquals((Object)new Long(99L), (Object)series.getY(0));
        XYSeriesTests.assertEquals((Object)new Long(3L), (Object)series.getY(1));
    }

    public void testAddOrUpdate2() {
        XYSeries series = new XYSeries((Comparable)((Object)"Series"), false, true);
        series.add(5.0, 5.5);
        series.add(6.0, 6.6);
        series.add(3.0, 3.3);
        series.add(4.0, 4.4);
        series.add(2.0, 2.2);
        series.add(1.0, 1.1);
        series.addOrUpdate(new Double(3.0), new Double(33.3));
        series.addOrUpdate(new Double(2.0), new Double(22.2));
        XYSeriesTests.assertEquals((double)33.3, (double)series.getY(2).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)22.2, (double)series.getY(4).doubleValue(), (double)1.0E-10);
    }

    public void testAdd() {
        XYSeries series = new XYSeries((Comparable)((Object)"Series"), false, true);
        series.add(5.0, 5.5);
        series.add(5.1, 5.51);
        series.add(6.0, 6.6);
        series.add(3.0, 3.3);
        series.add(4.0, 4.4);
        series.add(2.0, 2.2);
        series.add(1.0, 1.1);
        XYSeriesTests.assertEquals((double)5.5, (double)series.getY(0).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)5.51, (double)series.getY(1).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)6.6, (double)series.getY(2).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)3.3, (double)series.getY(3).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)4.4, (double)series.getY(4).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)2.2, (double)series.getY(5).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)1.1, (double)series.getY(6).doubleValue(), (double)1.0E-10);
    }

    public void testSetMaximumItemCount() {
        XYSeries s1 = new XYSeries((Comparable)((Object)"S1"));
        XYSeriesTests.assertEquals((int)Integer.MAX_VALUE, (int)s1.getMaximumItemCount());
        s1.setMaximumItemCount(2);
        XYSeriesTests.assertEquals((int)2, (int)s1.getMaximumItemCount());
        s1.add(1.0, 1.1);
        s1.add(2.0, 2.2);
        s1.add(3.0, 3.3);
        XYSeriesTests.assertEquals((double)2.0, (double)s1.getX(0).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)3.0, (double)s1.getX(1).doubleValue(), (double)1.0E-10);
    }

    public void testSetMaximumItemCount2() {
        XYSeries s1 = new XYSeries((Comparable)((Object)"S1"));
        s1.add(1.0, 1.1);
        s1.add(2.0, 2.2);
        s1.add(3.0, 3.3);
        s1.setMaximumItemCount(2);
        XYSeriesTests.assertEquals((double)2.0, (double)s1.getX(0).doubleValue(), (double)1.0E-10);
        XYSeriesTests.assertEquals((double)3.0, (double)s1.getX(1).doubleValue(), (double)1.0E-10);
    }
}

