/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.xy.IntervalXYDelegate;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class IntervalXYDelegateTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(IntervalXYDelegateTests.class);
    }

    public IntervalXYDelegateTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYSeries s1 = new XYSeries((Comparable)((Object)"Series"));
        s1.add(1.2, 3.4);
        XYSeriesCollection c1 = new XYSeriesCollection();
        c1.addSeries(s1);
        IntervalXYDelegate d1 = new IntervalXYDelegate(c1);
        XYSeries s2 = new XYSeries((Comparable)((Object)"Series"));
        XYSeriesCollection c2 = new XYSeriesCollection();
        s2.add(1.2, 3.4);
        c2.addSeries(s2);
        IntervalXYDelegate d2 = new IntervalXYDelegate(c2);
        IntervalXYDelegateTests.assertTrue((boolean)d1.equals(d2));
        IntervalXYDelegateTests.assertTrue((boolean)d2.equals(d1));
        d1.setAutoWidth(false);
        IntervalXYDelegateTests.assertFalse((boolean)d1.equals(d2));
        d2.setAutoWidth(false);
        IntervalXYDelegateTests.assertTrue((boolean)d1.equals(d2));
        d1.setIntervalPositionFactor(0.123);
        IntervalXYDelegateTests.assertFalse((boolean)d1.equals(d2));
        d2.setIntervalPositionFactor(0.123);
        IntervalXYDelegateTests.assertTrue((boolean)d1.equals(d2));
        d1.setIntervalWidth(1.23);
        IntervalXYDelegateTests.assertFalse((boolean)d1.equals(d2));
        d2.setIntervalWidth(1.23);
        IntervalXYDelegateTests.assertTrue((boolean)d1.equals(d2));
    }

    public void testCloning() {
        XYSeries s1 = new XYSeries((Comparable)((Object)"Series"));
        s1.add(1.2, 3.4);
        XYSeriesCollection c1 = new XYSeriesCollection();
        c1.addSeries(s1);
        IntervalXYDelegate d1 = new IntervalXYDelegate(c1);
        IntervalXYDelegate d2 = null;
        try {
            d2 = (IntervalXYDelegate)d1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        IntervalXYDelegateTests.assertTrue((d1 != d2 ? 1 : 0) != 0);
        IntervalXYDelegateTests.assertTrue((d1.getClass() == d2.getClass() ? 1 : 0) != 0);
        IntervalXYDelegateTests.assertTrue((boolean)d1.equals(d2));
    }

    public void testSerialization() {
        XYSeries s1 = new XYSeries((Comparable)((Object)"Series"));
        s1.add(1.2, 3.4);
        XYSeriesCollection c1 = new XYSeriesCollection();
        c1.addSeries(s1);
        IntervalXYDelegate d1 = new IntervalXYDelegate(c1);
        IntervalXYDelegate d2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(d1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            d2 = (IntervalXYDelegate)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        IntervalXYDelegateTests.assertEquals((Object)d1, d2);
    }
}

