/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.xy.DefaultOHLCDataset;
import org.jfree.data.xy.OHLCDataItem;

public class DefaultOHLCDatasetTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DefaultOHLCDatasetTests.class);
    }

    public DefaultOHLCDatasetTests(String name) {
        super(name);
    }

    public void testEquals() {
        DefaultOHLCDataset d1 = new DefaultOHLCDataset((Comparable)((Object)"Series 1"), new OHLCDataItem[0]);
        DefaultOHLCDataset d2 = new DefaultOHLCDataset((Comparable)((Object)"Series 1"), new OHLCDataItem[0]);
        DefaultOHLCDatasetTests.assertTrue((boolean)d1.equals(d2));
        DefaultOHLCDatasetTests.assertTrue((boolean)d2.equals(d1));
    }

    public void testCloning() {
        DefaultOHLCDataset d1 = new DefaultOHLCDataset((Comparable)((Object)"Series 1"), new OHLCDataItem[0]);
        DefaultOHLCDataset d2 = null;
        try {
            d2 = (DefaultOHLCDataset)d1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        DefaultOHLCDatasetTests.assertTrue((d1 != d2 ? 1 : 0) != 0);
        DefaultOHLCDatasetTests.assertTrue((d1.getClass() == d2.getClass() ? 1 : 0) != 0);
        DefaultOHLCDatasetTests.assertTrue((boolean)d1.equals(d2));
    }

    public void testSerialization() {
        DefaultOHLCDataset d1 = new DefaultOHLCDataset((Comparable)((Object)"Series 1"), new OHLCDataItem[0]);
        DefaultOHLCDataset d2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(d1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            d2 = (DefaultOHLCDataset)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        DefaultOHLCDatasetTests.assertEquals((Object)d1, d2);
    }
}

