/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.time.Year;

public class TimeTableXYDatasetTests
extends TestCase {
    private static final double DELTA = 1.0E-10;

    public static Test suite() {
        return new TestSuite(TimeTableXYDatasetTests.class);
    }

    public TimeTableXYDatasetTests(String name) {
        super(name);
    }

    public void testStandard() {
        TimeTableXYDataset d = new TimeTableXYDataset();
        d.add(new Year(1999), 1.0, "Series 1");
        TimeTableXYDatasetTests.assertEquals((int)d.getItemCount(), (int)1);
        TimeTableXYDatasetTests.assertEquals((int)d.getSeriesCount(), (int)1);
        d.add(new Year(2000), 2.0, "Series 2");
        TimeTableXYDatasetTests.assertEquals((int)d.getItemCount(), (int)2);
        TimeTableXYDatasetTests.assertEquals((int)d.getSeriesCount(), (int)2);
        TimeTableXYDatasetTests.assertEquals((double)d.getYValue(0, 0), (double)1.0, (double)1.0E-10);
        TimeTableXYDatasetTests.assertTrue((boolean)Double.isNaN(d.getYValue(0, 1)));
        TimeTableXYDatasetTests.assertTrue((boolean)Double.isNaN(d.getYValue(1, 0)));
        TimeTableXYDatasetTests.assertEquals((double)d.getYValue(1, 1), (double)2.0, (double)1.0E-10);
    }

    public void testGetTimePeriod() {
        TimeTableXYDataset d = new TimeTableXYDataset();
        d.add(new Year(1999), 1.0, "Series 1");
        d.add(new Year(1998), 2.0, "Series 1");
        d.add(new Year(1996), 3.0, "Series 1");
        TimeTableXYDatasetTests.assertEquals((Object)d.getTimePeriod(0), (Object)new Year(1996));
        TimeTableXYDatasetTests.assertEquals((Object)d.getTimePeriod(1), (Object)new Year(1998));
        TimeTableXYDatasetTests.assertEquals((Object)d.getTimePeriod(2), (Object)new Year(1999));
    }

    public void testEquals() {
        TimeTableXYDataset d1 = new TimeTableXYDataset();
        TimeTableXYDataset d2 = new TimeTableXYDataset();
        TimeTableXYDatasetTests.assertTrue((boolean)d1.equals(d2));
        TimeTableXYDatasetTests.assertTrue((boolean)d2.equals(d1));
        d1.add(new Year(1999), 123.4, "S1");
        TimeTableXYDatasetTests.assertFalse((boolean)d1.equals(d2));
        d2.add(new Year(1999), 123.4, "S1");
        TimeTableXYDatasetTests.assertTrue((boolean)d1.equals(d2));
        d1.setDomainIsPointsInTime(!d1.getDomainIsPointsInTime());
        TimeTableXYDatasetTests.assertFalse((boolean)d1.equals(d2));
        d2.setDomainIsPointsInTime(!d2.getDomainIsPointsInTime());
        TimeTableXYDatasetTests.assertTrue((boolean)d1.equals(d2));
        d1 = new TimeTableXYDataset(TimeZone.getTimeZone("GMT"));
        d2 = new TimeTableXYDataset(TimeZone.getTimeZone("America/Los_Angeles"));
        TimeTableXYDatasetTests.assertFalse((boolean)d1.equals(d2));
    }

    public void testClone() {
        TimeTableXYDataset d = new TimeTableXYDataset();
        d.add(new Year(1999), 25.0, "Series");
        TimeTableXYDataset clone = null;
        try {
            clone = (TimeTableXYDataset)d.clone();
        }
        catch (CloneNotSupportedException e) {
            TimeTableXYDatasetTests.assertTrue((boolean)false);
        }
        TimeTableXYDatasetTests.assertTrue((boolean)clone.equals(d));
        clone.add(new Year(2004), 1.2, "SS");
        TimeTableXYDatasetTests.assertFalse((boolean)clone.equals(d));
    }

    public void testSerialization() {
        TimeTableXYDataset d1 = new TimeTableXYDataset();
        d1.add(new Year(1999), 123.4, "S1");
        TimeTableXYDataset d2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(d1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            d2 = (TimeTableXYDataset)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        TimeTableXYDatasetTests.assertTrue((boolean)d1.equals(d2));
    }
}

