/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimePeriodValues;
import org.jfree.data.time.TimePeriodValuesCollection;

public class TimePeriodValuesCollectionTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(TimePeriodValuesCollectionTests.class);
    }

    public TimePeriodValuesCollectionTests(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void test1161340() {
        TimePeriodValuesCollection dataset = new TimePeriodValuesCollection();
        TimePeriodValues v1 = new TimePeriodValues("V1");
        v1.add((TimePeriod)new Day(11, 3, 2005), 1.2);
        v1.add((TimePeriod)new Day(12, 3, 2005), 3.4);
        dataset.addSeries(v1);
        TimePeriodValuesCollectionTests.assertEquals((int)1, (int)dataset.getSeriesCount());
        dataset.removeSeries(v1);
        TimePeriodValuesCollectionTests.assertEquals((int)0, (int)dataset.getSeriesCount());
        TimePeriodValues v2 = new TimePeriodValues("V2");
        v1.add((TimePeriod)new Day(5, 3, 2005), 1.2);
        v1.add((TimePeriod)new Day(6, 3, 2005), 3.4);
        dataset.addSeries(v2);
        TimePeriodValuesCollectionTests.assertEquals((int)1, (int)dataset.getSeriesCount());
    }

    public void testEquals() {
        TimePeriodValuesCollection c1 = new TimePeriodValuesCollection();
        TimePeriodValuesCollection c2 = new TimePeriodValuesCollection();
        TimePeriodValuesCollectionTests.assertTrue((boolean)c1.equals(c2));
        c1.setDomainIsPointsInTime(!c1.getDomainIsPointsInTime());
        TimePeriodValuesCollectionTests.assertFalse((boolean)c1.equals(c2));
        c2.setDomainIsPointsInTime(c1.getDomainIsPointsInTime());
        TimePeriodValuesCollectionTests.assertTrue((boolean)c1.equals(c2));
        c1.setXPosition(TimePeriodAnchor.END);
        TimePeriodValuesCollectionTests.assertFalse((boolean)c1.equals(c2));
        c2.setXPosition(TimePeriodAnchor.END);
        TimePeriodValuesCollectionTests.assertTrue((boolean)c1.equals(c2));
        TimePeriodValues v1 = new TimePeriodValues("Test");
        TimePeriodValues v2 = new TimePeriodValues("Test");
        c1.addSeries(v1);
        TimePeriodValuesCollectionTests.assertFalse((boolean)c1.equals(c2));
        c2.addSeries(v2);
        TimePeriodValuesCollectionTests.assertTrue((boolean)c1.equals(c2));
    }

    public void testSerialization() {
        TimePeriodValuesCollection c1 = new TimePeriodValuesCollection();
        TimePeriodValuesCollection c2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(c1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            c2 = (TimePeriodValuesCollection)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        TimePeriodValuesCollectionTests.assertEquals((Object)c1, c2);
    }
}

