/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.SimpleTimePeriod;

public class SimpleTimePeriodTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(SimpleTimePeriodTests.class);
    }

    public SimpleTimePeriodTests(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testEqualsSelf() {
        SimpleTimePeriod p = new SimpleTimePeriod(new Date(1000L), new Date(1001L));
        SimpleTimePeriodTests.assertTrue((boolean)p.equals(p));
    }

    public void testEquals() {
        SimpleTimePeriod p1 = new SimpleTimePeriod(new Date(1000L), new Date(1004L));
        SimpleTimePeriod p2 = new SimpleTimePeriod(new Date(1000L), new Date(1004L));
        SimpleTimePeriodTests.assertTrue((boolean)p1.equals(p2));
        SimpleTimePeriodTests.assertTrue((boolean)p2.equals(p1));
        p1 = new SimpleTimePeriod(new Date(1002L), new Date(1004L));
        SimpleTimePeriodTests.assertFalse((boolean)p1.equals(p2));
        p2 = new SimpleTimePeriod(new Date(1002L), new Date(1004L));
        SimpleTimePeriodTests.assertTrue((boolean)p1.equals(p2));
        p1 = new SimpleTimePeriod(new Date(1002L), new Date(1003L));
        SimpleTimePeriodTests.assertFalse((boolean)p1.equals(p2));
        p2 = new SimpleTimePeriod(new Date(1002L), new Date(1003L));
        SimpleTimePeriodTests.assertTrue((boolean)p1.equals(p2));
    }

    public void testSerialization() {
        SimpleTimePeriod p1 = new SimpleTimePeriod(new Date(1000L), new Date(1001L));
        SimpleTimePeriod p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (SimpleTimePeriod)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        SimpleTimePeriodTests.assertEquals((Object)p1, p2);
    }

    public void testHashcode() {
        SimpleTimePeriod s1 = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriod s2 = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriodTests.assertTrue((boolean)s1.equals(s2));
        int h1 = s1.hashCode();
        int h2 = s2.hashCode();
        SimpleTimePeriodTests.assertEquals((int)h1, (int)h2);
    }

    public void testClone() {
        SimpleTimePeriod s1 = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriodTests.assertFalse((boolean)(s1 instanceof Cloneable));
    }

    public void testCompareTo() {
        SimpleTimePeriod s1 = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriod s2 = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriodTests.assertEquals((int)0, (int)s1.compareTo(s2));
        s1 = new SimpleTimePeriod(new Date(9L), new Date(21L));
        s2 = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriodTests.assertEquals((int)-1, (int)s1.compareTo(s2));
        s1 = new SimpleTimePeriod(new Date(11L), new Date(19L));
        s2 = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriodTests.assertEquals((int)1, (int)s1.compareTo(s2));
        s1 = new SimpleTimePeriod(new Date(9L), new Date(19L));
        s2 = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriodTests.assertEquals((int)-1, (int)s1.compareTo(s2));
        s1 = new SimpleTimePeriod(new Date(11L), new Date(21L));
        s2 = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriodTests.assertEquals((int)1, (int)s1.compareTo(s2));
        s1 = new SimpleTimePeriod(new Date(10L), new Date(18L));
        s2 = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriodTests.assertEquals((int)-1, (int)s1.compareTo(s2));
        s1 = new SimpleTimePeriod(new Date(10L), new Date(22L));
        s2 = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriodTests.assertEquals((int)1, (int)s1.compareTo(s2));
    }
}

