/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Second;

public class SecondTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(SecondTests.class);
    }

    public SecondTests(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testEqualsSelf() {
        Second second = new Second();
        SecondTests.assertTrue((boolean)second.equals(second));
    }

    public void testEquals() {
        Day day1 = new Day(29, 3, 2002);
        Hour hour1 = new Hour(15, day1);
        Minute minute1 = new Minute(15, hour1);
        Second second1 = new Second(34, minute1);
        Day day2 = new Day(29, 3, 2002);
        Hour hour2 = new Hour(15, day2);
        Minute minute2 = new Minute(15, hour2);
        Second second2 = new Second(34, minute2);
        SecondTests.assertTrue((boolean)second1.equals(second2));
    }

    public void testDateConstructor1() {
        TimeZone zone = TimeZone.getTimeZone("GMT");
        Second s1 = new Second(new Date(1016729758999L), zone);
        Second s2 = new Second(new Date(1016729759000L), zone);
        SecondTests.assertEquals((int)58, (int)s1.getSecond());
        SecondTests.assertEquals((long)1016729758999L, (long)s1.getLastMillisecond(zone));
        SecondTests.assertEquals((int)59, (int)s2.getSecond());
        SecondTests.assertEquals((long)1016729759000L, (long)s2.getFirstMillisecond(zone));
    }

    public void testDateConstructor2() {
        TimeZone zone = TimeZone.getTimeZone("America/Chicago");
        Second s1 = new Second(new Date(1016751358999L), zone);
        Second s2 = new Second(new Date(1016751359000L), zone);
        SecondTests.assertEquals((int)58, (int)s1.getSecond());
        SecondTests.assertEquals((long)1016751358999L, (long)s1.getLastMillisecond(zone));
        SecondTests.assertEquals((int)59, (int)s2.getSecond());
        SecondTests.assertEquals((long)1016751359000L, (long)s2.getFirstMillisecond(zone));
    }

    public void testSerialization() {
        Second s1 = new Second();
        Second s2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(s1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            s2 = (Second)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        SecondTests.assertEquals((Object)s1, s2);
    }

    public void testHashcode() {
        Second s1 = new Second(13, 45, 5, 1, 2, 2003);
        Second s2 = new Second(13, 45, 5, 1, 2, 2003);
        SecondTests.assertTrue((boolean)s1.equals(s2));
        int h1 = s1.hashCode();
        int h2 = s2.hashCode();
        SecondTests.assertEquals((int)h1, (int)h2);
    }

    public void testNotCloneable() {
        Second s = new Second(13, 45, 5, 1, 2, 2003);
        SecondTests.assertFalse((boolean)(s instanceof Cloneable));
    }
}

