/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Second;

public class MillisecondTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(MillisecondTests.class);
    }

    public MillisecondTests(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testEqualsSelf() {
        Millisecond millisecond = new Millisecond();
        MillisecondTests.assertTrue((boolean)millisecond.equals(millisecond));
    }

    public void testEquals() {
        Day day1 = new Day(29, 3, 2002);
        Hour hour1 = new Hour(15, day1);
        Minute minute1 = new Minute(15, hour1);
        Second second1 = new Second(34, minute1);
        Millisecond milli1 = new Millisecond(999, second1);
        Day day2 = new Day(29, 3, 2002);
        Hour hour2 = new Hour(15, day2);
        Minute minute2 = new Minute(15, hour2);
        Second second2 = new Second(34, minute2);
        Millisecond milli2 = new Millisecond(999, second2);
        MillisecondTests.assertTrue((boolean)milli1.equals(milli2));
    }

    public void testDateConstructor1() {
        TimeZone zone = TimeZone.getTimeZone("GMT");
        Millisecond m1 = new Millisecond(new Date(1016729759122L), zone);
        Millisecond m2 = new Millisecond(new Date(1016729759123L), zone);
        MillisecondTests.assertEquals((long)122L, (long)m1.getMillisecond());
        MillisecondTests.assertEquals((long)1016729759122L, (long)m1.getLastMillisecond(zone));
        MillisecondTests.assertEquals((long)123L, (long)m2.getMillisecond());
        MillisecondTests.assertEquals((long)1016729759123L, (long)m2.getFirstMillisecond(zone));
    }

    public void testDateConstructor2() {
        TimeZone zone = TimeZone.getTimeZone("Europe/Tallinn");
        Millisecond m1 = new Millisecond(new Date(1016722559122L), zone);
        Millisecond m2 = new Millisecond(new Date(1016722559123L), zone);
        MillisecondTests.assertEquals((long)122L, (long)m1.getMillisecond());
        MillisecondTests.assertEquals((long)1016722559122L, (long)m1.getLastMillisecond(zone));
        MillisecondTests.assertEquals((long)123L, (long)m2.getMillisecond());
        MillisecondTests.assertEquals((long)1016722559123L, (long)m2.getFirstMillisecond(zone));
    }

    public void testSerialization() {
        Millisecond m1 = new Millisecond();
        Millisecond m2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(m1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            m2 = (Millisecond)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        MillisecondTests.assertEquals((Object)m1, m2);
    }

    public void testHashcode() {
        Millisecond m1 = new Millisecond(599, 23, 45, 7, 9, 10, 2007);
        Millisecond m2 = new Millisecond(599, 23, 45, 7, 9, 10, 2007);
        MillisecondTests.assertTrue((boolean)m1.equals(m2));
        int hash1 = m1.hashCode();
        int hash2 = m2.hashCode();
        MillisecondTests.assertEquals((int)hash1, (int)hash2);
    }

    public void test943985() {
        Millisecond ms = new Millisecond(new Date(4L));
        MillisecondTests.assertEquals((long)ms.getFirstMillisecond(), (long)ms.getMiddleMillisecond());
        MillisecondTests.assertEquals((long)ms.getMiddleMillisecond(), (long)ms.getLastMillisecond());
        ms = new Millisecond(new Date(5L));
        MillisecondTests.assertEquals((long)ms.getFirstMillisecond(), (long)ms.getMiddleMillisecond());
        MillisecondTests.assertEquals((long)ms.getMiddleMillisecond(), (long)ms.getLastMillisecond());
    }

    public void testNotCloneable() {
        Millisecond m = new Millisecond(599, 23, 45, 7, 9, 10, 2007);
        MillisecondTests.assertFalse((boolean)(m instanceof Cloneable));
    }
}

