/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics.junit;

import java.util.ArrayList;
import java.util.Collections;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.statistics.Statistics;

public class StatisticsTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StatisticsTests.class);
    }

    public StatisticsTests(String name) {
        super(name);
    }

    public void testCalculateMean1() {
        ArrayList<Double> values = new ArrayList<Double>();
        values.add(new Double(9.0));
        values.add(new Double(3.0));
        values.add(new Double(2.0));
        values.add(new Double(2.0));
        double mean = Statistics.calculateMean(values);
        StatisticsTests.assertEquals((double)4.0, (double)mean, (double)1.0E-7);
    }

    public void testCalculateMean2() {
        Number[] values = new Number[]{new Double(1.0), new Double(2.0), new Double(3.0)};
        double mean = Statistics.calculateMean(values);
        StatisticsTests.assertEquals((double)2.0, (double)mean, (double)1.0E-7);
    }

    public void testCalculateMedian1() {
        ArrayList<Double> values = new ArrayList<Double>();
        values.add(new Double(1.0));
        double median = Statistics.calculateMedian(values);
        StatisticsTests.assertEquals((double)1.0, (double)median, (double)1.0E-7);
    }

    public void testCalculateMedian2() {
        ArrayList<Double> values = new ArrayList<Double>();
        values.add(new Double(2.0));
        values.add(new Double(1.0));
        double median = Statistics.calculateMedian(values);
        StatisticsTests.assertEquals((double)1.5, (double)median, (double)1.0E-7);
    }

    public void testCalculateMedian3() {
        ArrayList<Double> values = new ArrayList<Double>();
        values.add(new Double(1.0));
        values.add(new Double(2.0));
        values.add(new Double(3.0));
        values.add(new Double(6.0));
        values.add(new Double(5.0));
        values.add(new Double(4.0));
        double median = Statistics.calculateMedian(values);
        StatisticsTests.assertEquals((double)3.5, (double)median, (double)1.0E-7);
    }

    public void testCalculateMedian4() {
        ArrayList<Double> values = new ArrayList<Double>();
        values.add(new Double(7.0));
        values.add(new Double(2.0));
        values.add(new Double(3.0));
        values.add(new Double(5.0));
        values.add(new Double(4.0));
        values.add(new Double(6.0));
        values.add(new Double(1.0));
        double median = Statistics.calculateMedian(values);
        StatisticsTests.assertEquals((double)4.0, (double)median, (double)1.0E-7);
    }

    public void testCalculateMedian5() {
        ArrayList<Double> values = new ArrayList<Double>();
        values.add(new Double(11.228692993861783));
        values.add(new Double(11.30823353859889));
        values.add(new Double(11.75312904769314));
        values.add(new Double(11.825102897465314));
        values.add(new Double(10.184252778401783));
        values.add(new Double(12.207951828057766));
        values.add(new Double(10.68841994040566));
        values.add(new Double(12.099522004479438));
        values.add(new Double(11.508874945056881));
        values.add(new Double(12.052517729558513));
        values.add(new Double(12.401481645578734));
        values.add(new Double(12.185377793028543));
        values.add(new Double(10.666372951930315));
        values.add(new Double(11.680978041499548));
        values.add(new Double(11.06528277406718));
        values.add(new Double(11.36876492904596));
        values.add(new Double(11.927565516175939));
        values.add(new Double(11.39307785978655));
        values.add(new Double(11.989603679523857));
        values.add(new Double(12.009834360354864));
        values.add(new Double(10.653351822461559));
        values.add(new Double(11.851776254376754));
        values.add(new Double(11.045441544755946));
        values.add(new Double(11.993674040560624));
        values.add(new Double(12.898219965238944));
        values.add(new Double(11.97095782819647));
        values.add(new Double(11.73234406745488));
        values.add(new Double(11.649006017243991));
        values.add(new Double(12.20549704915365));
        values.add(new Double(11.799723639384919));
        values.add(new Double(11.896208658005628));
        values.add(new Double(12.164149111823424));
        values.add(new Double(12.042795103513766));
        values.add(new Double(12.114839532596426));
        values.add(new Double(12.166609097075824));
        values.add(new Double(12.183017546225935));
        values.add(new Double(11.622009125845342));
        values.add(new Double(11.289365786738633));
        values.add(new Double(12.462984323671568));
        values.add(new Double(11.573494921030598));
        values.add(new Double(10.862867940485804));
        values.add(new Double(12.018186939664872));
        values.add(new Double(10.418046849313018));
        values.add(new Double(11.326344465881341));
        double median = Statistics.calculateMedian(values, true);
        StatisticsTests.assertEquals((double)11.812413268425116, (double)median, (double)1.0E-6);
        Collections.sort(values);
        double median2 = Statistics.calculateMedian(values, false);
        StatisticsTests.assertEquals((double)11.812413268425116, (double)median2, (double)1.0E-6);
    }

    public void testCalculateMedian6() {
        ArrayList<Double> values = new ArrayList<Double>();
        values.add(new Double(7.0));
        values.add(new Double(2.0));
        values.add(new Double(3.0));
        values.add(new Double(5.0));
        values.add(new Double(4.0));
        values.add(new Double(6.0));
        values.add(new Double(1.0));
        double median = Statistics.calculateMedian(values, 0, 2);
        StatisticsTests.assertEquals((double)3.0, (double)median, (double)1.0E-7);
    }

    public void testCorrelation1() {
        Number[] data1 = new Number[]{new Double(1.0), new Double(2.0), new Double(3.0)};
        Number[] data2 = new Number[]{new Double(1.0), new Double(2.0), new Double(3.0)};
        double r = Statistics.getCorrelation(data1, data2);
        StatisticsTests.assertEquals((double)1.0, (double)r, (double)1.0E-8);
    }

    public void testCorrelation2() {
        Number[] data1 = new Number[]{new Double(68.0), new Double(71.0), new Double(62.0), new Double(75.0), new Double(58.0), new Double(60.0), new Double(67.0), new Double(68.0), new Double(71.0), new Double(69.0), new Double(68.0), new Double(67.0), new Double(63.0), new Double(62.0), new Double(60.0), new Double(63.0), new Double(65.0), new Double(67.0), new Double(63.0), new Double(61.0)};
        Number[] data2 = new Number[]{new Double(4.1), new Double(4.6), new Double(3.8), new Double(4.4), new Double(3.2), new Double(3.1), new Double(3.8), new Double(4.1), new Double(4.3), new Double(3.7), new Double(3.5), new Double(3.2), new Double(3.7), new Double(3.3), new Double(3.4), new Double(4.0), new Double(4.1), new Double(3.8), new Double(3.4), new Double(3.6)};
        double r = Statistics.getCorrelation(data1, data2);
        StatisticsTests.assertEquals((double)0.7306356862792885, (double)r, (double)1.0E-12);
    }
}

