/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.statistics.SimpleHistogramBin;
import org.jfree.data.statistics.SimpleHistogramDataset;

public class SimpleHistogramDatasetTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(SimpleHistogramDatasetTests.class);
    }

    public SimpleHistogramDatasetTests(String name) {
        super(name);
    }

    public void testEquals() {
        SimpleHistogramDataset d1 = new SimpleHistogramDataset((Comparable)((Object)"Dataset 1"));
        SimpleHistogramDataset d2 = new SimpleHistogramDataset((Comparable)((Object)"Dataset 1"));
        SimpleHistogramDatasetTests.assertTrue((boolean)d1.equals(d2));
        d1.addBin(new SimpleHistogramBin(1.0, 2.0));
        SimpleHistogramDatasetTests.assertFalse((boolean)d1.equals(d2));
        d2.addBin(new SimpleHistogramBin(1.0, 2.0));
        SimpleHistogramDatasetTests.assertTrue((boolean)d1.equals(d2));
    }

    public void testCloning() {
        SimpleHistogramDataset d1 = new SimpleHistogramDataset((Comparable)((Object)"Dataset 1"));
        SimpleHistogramDataset d2 = null;
        try {
            d2 = (SimpleHistogramDataset)d1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        SimpleHistogramDatasetTests.assertTrue((d1 != d2 ? 1 : 0) != 0);
        SimpleHistogramDatasetTests.assertTrue((d1.getClass() == d2.getClass() ? 1 : 0) != 0);
        SimpleHistogramDatasetTests.assertTrue((boolean)d1.equals(d2));
        d2.addBin(new SimpleHistogramBin(2.0, 3.0));
        d2.addObservation(2.3);
        SimpleHistogramDatasetTests.assertFalse((boolean)d1.equals(d2));
    }

    public void testSerialization() {
        SimpleHistogramDataset d1 = new SimpleHistogramDataset((Comparable)((Object)"D1"));
        SimpleHistogramDataset d2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(d1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            d2 = (SimpleHistogramDataset)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        SimpleHistogramDatasetTests.assertEquals((Object)d1, d2);
    }
}

