/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.KeyedObjects2D;

public class KeyedObjects2DTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(KeyedObjects2DTests.class);
    }

    public KeyedObjects2DTests(String name) {
        super(name);
    }

    public void testCloning() {
        KeyedObjects2D o1 = new KeyedObjects2D();
        o1.setObject(new Integer(1), (Comparable)((Object)"V1"), (Comparable)((Object)"C1"));
        o1.setObject(null, (Comparable)((Object)"V2"), (Comparable)((Object)"C1"));
        o1.setObject(new Integer(3), (Comparable)((Object)"V3"), (Comparable)((Object)"C2"));
        KeyedObjects2D o2 = null;
        try {
            o2 = (KeyedObjects2D)o1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        KeyedObjects2DTests.assertTrue((o1 != o2 ? 1 : 0) != 0);
        KeyedObjects2DTests.assertTrue((o1.getClass() == o2.getClass() ? 1 : 0) != 0);
        KeyedObjects2DTests.assertTrue((boolean)o1.equals(o2));
    }

    public void testSerialization() {
        KeyedObjects2D ko2D1 = new KeyedObjects2D();
        ko2D1.addObject(new Double(234.2), (Comparable)((Object)"Row1"), (Comparable)((Object)"Col1"));
        ko2D1.addObject(null, (Comparable)((Object)"Row1"), (Comparable)((Object)"Col2"));
        ko2D1.addObject(new Double(345.9), (Comparable)((Object)"Row2"), (Comparable)((Object)"Col1"));
        ko2D1.addObject(new Double(452.7), (Comparable)((Object)"Row2"), (Comparable)((Object)"Col2"));
        KeyedObjects2D ko2D2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(ko2D1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            ko2D2 = (KeyedObjects2D)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        KeyedObjects2DTests.assertEquals((Object)ko2D1, ko2D2);
    }
}

