/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.KeyedObject;

public class KeyedObjectTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(KeyedObjectTests.class);
    }

    public KeyedObjectTests(String name) {
        super(name);
    }

    public void testEquals() {
        KeyedObject ko1 = new KeyedObject((Comparable)((Object)"Test"), "Object");
        KeyedObject ko2 = new KeyedObject((Comparable)((Object)"Test"), "Object");
        KeyedObjectTests.assertTrue((boolean)ko1.equals(ko2));
        KeyedObjectTests.assertTrue((boolean)ko2.equals(ko1));
        ko1 = new KeyedObject((Comparable)((Object)"Test 1"), "Object");
        ko2 = new KeyedObject((Comparable)((Object)"Test 2"), "Object");
        KeyedObjectTests.assertFalse((boolean)ko1.equals(ko2));
        ko1 = new KeyedObject((Comparable)((Object)"Test"), "Object 1");
        ko2 = new KeyedObject((Comparable)((Object)"Test"), "Object 2");
        KeyedObjectTests.assertFalse((boolean)ko1.equals(ko2));
    }

    public void testCloning() {
        KeyedObject ko1 = new KeyedObject((Comparable)((Object)"Test"), "Object");
        KeyedObject ko2 = null;
        try {
            ko2 = (KeyedObject)ko1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        KeyedObjectTests.assertTrue((ko1 != ko2 ? 1 : 0) != 0);
        KeyedObjectTests.assertTrue((ko1.getClass() == ko2.getClass() ? 1 : 0) != 0);
        KeyedObjectTests.assertTrue((boolean)ko1.equals(ko2));
    }

    public void testSerialization() {
        KeyedObject ko1 = new KeyedObject((Comparable)((Object)"Test"), "Object");
        KeyedObject ko2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(ko1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            ko2 = (KeyedObject)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        KeyedObjectTests.assertEquals((Object)ko1, ko2);
    }
}

