/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.DefaultKeyedValues2D;

public class DefaultKeyedValues2DTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DefaultKeyedValues2DTests.class);
    }

    public DefaultKeyedValues2DTests(String name) {
        super(name);
    }

    public void testCloning() {
        DefaultKeyedValues2D v1 = new DefaultKeyedValues2D();
        v1.setValue(new Integer(1), (Comparable)((Object)"V1"), (Comparable)((Object)"C1"));
        v1.setValue(null, (Comparable)((Object)"V2"), (Comparable)((Object)"C1"));
        v1.setValue(new Integer(3), (Comparable)((Object)"V3"), (Comparable)((Object)"C2"));
        DefaultKeyedValues2D v2 = null;
        try {
            v2 = (DefaultKeyedValues2D)v1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        DefaultKeyedValues2DTests.assertTrue((v1 != v2 ? 1 : 0) != 0);
        DefaultKeyedValues2DTests.assertTrue((v1.getClass() == v2.getClass() ? 1 : 0) != 0);
        DefaultKeyedValues2DTests.assertTrue((boolean)v1.equals(v2));
        v2.setValue(new Integer(2), (Comparable)((Object)"V2"), (Comparable)((Object)"C1"));
        DefaultKeyedValues2DTests.assertFalse((boolean)v1.equals(v2));
    }

    public void testSerialization() {
        DefaultKeyedValues2D kv2D1 = new DefaultKeyedValues2D();
        kv2D1.addValue(new Double(234.2), (Comparable)((Object)"Row1"), (Comparable)((Object)"Col1"));
        kv2D1.addValue(null, (Comparable)((Object)"Row1"), (Comparable)((Object)"Col2"));
        kv2D1.addValue(new Double(345.9), (Comparable)((Object)"Row2"), (Comparable)((Object)"Col1"));
        kv2D1.addValue(new Double(452.7), (Comparable)((Object)"Row2"), (Comparable)((Object)"Col2"));
        DefaultKeyedValues2D kv2D2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(kv2D1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            kv2D2 = (DefaultKeyedValues2D)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        DefaultKeyedValues2DTests.assertEquals((Object)kv2D1, kv2D2);
    }
}

