/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.gantt.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;

public class TaskSeriesTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(TaskSeriesTests.class);
    }

    public TaskSeriesTests(String name) {
        super(name);
    }

    public void testEquals() {
        TaskSeries s1 = new TaskSeries("S");
        s1.add(new Task("T1", new Date(1L), new Date(2L)));
        s1.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeries s2 = new TaskSeries("S");
        s2.add(new Task("T1", new Date(1L), new Date(2L)));
        s2.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeriesTests.assertTrue((boolean)s1.equals(s2));
        TaskSeriesTests.assertTrue((boolean)s2.equals(s1));
        s1.add(new Task("T3", new Date(22L), new Date(33L)));
        TaskSeriesTests.assertFalse((boolean)s1.equals(s2));
        s2.add(new Task("T3", new Date(22L), new Date(33L)));
        TaskSeriesTests.assertTrue((boolean)s1.equals(s2));
    }

    public void testCloning() {
        TaskSeries s1 = new TaskSeries("S");
        s1.add(new Task("T1", new Date(1L), new Date(2L)));
        s1.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeries s2 = null;
        try {
            s2 = (TaskSeries)s1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        TaskSeriesTests.assertTrue((s1 != s2 ? 1 : 0) != 0);
        TaskSeriesTests.assertTrue((s1.getClass() == s2.getClass() ? 1 : 0) != 0);
        TaskSeriesTests.assertTrue((boolean)s1.equals(s2));
    }

    public void testSerialization() {
        TaskSeries s1 = new TaskSeries("S");
        s1.add(new Task("T1", new Date(1L), new Date(2L)));
        s1.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeries s2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(s1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            s2 = (TaskSeries)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        TaskSeriesTests.assertEquals((Object)s1, s2);
    }

    public void testGetTask() {
        TaskSeries s1 = new TaskSeries("S");
        s1.add(new Task("T1", new Date(1L), new Date(2L)));
        s1.add(new Task("T2", new Date(11L), new Date(22L)));
        Task t1 = s1.get("T1");
        TaskSeriesTests.assertTrue((boolean)t1.equals(new Task("T1", new Date(1L), new Date(2L))));
        Task t2 = s1.get("T2");
        TaskSeriesTests.assertTrue((boolean)t2.equals(new Task("T2", new Date(11L), new Date(22L))));
        Task t3 = s1.get("T3");
        TaskSeriesTests.assertTrue((t3 == null ? 1 : 0) != 0);
    }
}

