/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.gantt.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.time.SimpleTimePeriod;

public class TaskSeriesCollectionTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(TaskSeriesCollectionTests.class);
    }

    public TaskSeriesCollectionTests(String name) {
        super(name);
    }

    private TaskSeriesCollection createCollection1() {
        TaskSeriesCollection result = new TaskSeriesCollection();
        TaskSeries s1 = new TaskSeries("S1");
        s1.add(new Task("Task 1", new Date(1L), new Date(2L)));
        s1.add(new Task("Task 2", new Date(3L), new Date(4L)));
        result.add(s1);
        TaskSeries s2 = new TaskSeries("S2");
        s2.add(new Task("Task 3", new Date(5L), new Date(6L)));
        result.add(s2);
        return result;
    }

    private TaskSeriesCollection createCollection2() {
        TaskSeriesCollection result = new TaskSeriesCollection();
        TaskSeries s1 = new TaskSeries("S1");
        Task t1 = new Task("Task 1", new Date(10L), new Date(20L));
        t1.addSubtask(new Task("Task 1A", new Date(10L), new Date(15L)));
        t1.addSubtask(new Task("Task 1B", new Date(16L), new Date(20L)));
        t1.setPercentComplete(0.1);
        s1.add(t1);
        Task t2 = new Task("Task 2", new Date(30L), new Date(40L));
        t2.addSubtask(new Task("Task 2A", new Date(30L), new Date(35L)));
        t2.addSubtask(new Task("Task 2B", new Date(36L), new Date(40L)));
        t2.setPercentComplete(0.2);
        s1.add(t2);
        result.add(s1);
        TaskSeries s2 = new TaskSeries("S2");
        Task t3 = new Task("Task 3", new Date(50L), new Date(60L));
        t3.addSubtask(new Task("Task 3A", new Date(50L), new Date(55L)));
        t3.addSubtask(new Task("Task 3B", new Date(56L), new Date(60L)));
        t3.setPercentComplete(0.3);
        s2.add(t3);
        result.add(s2);
        return result;
    }

    private TaskSeriesCollection createCollection3() {
        Task sub1 = new Task("Sub1", new Date(11L), new Date(111L));
        Task sub2 = new Task("Sub2", new Date(22L), new Date(222L));
        Task sub3 = new Task("Sub3", new Date(33L), new Date(333L));
        Task sub4 = new Task("Sub4", new Date(44L), new Date(444L));
        Task sub5 = new Task("Sub5", new Date(55L), new Date(555L));
        Task sub6 = new Task("Sub6", new Date(66L), new Date(666L));
        sub1.setPercentComplete(0.111);
        sub2.setPercentComplete(0.222);
        sub3.setPercentComplete(0.333);
        sub4.setPercentComplete(0.444);
        sub5.setPercentComplete(0.555);
        sub6.setPercentComplete(0.666);
        TaskSeries seriesA = new TaskSeries("Series A");
        Task taskA1 = new Task("Task 1", new SimpleTimePeriod(new Date(100L), new Date(200L)));
        taskA1.setPercentComplete(0.1);
        taskA1.addSubtask(sub1);
        Task taskA2 = new Task("Task 2", new SimpleTimePeriod(new Date(220L), new Date(350L)));
        taskA2.setPercentComplete(0.2);
        taskA2.addSubtask(sub2);
        taskA2.addSubtask(sub3);
        seriesA.add(taskA1);
        seriesA.add(taskA2);
        TaskSeries seriesB = new TaskSeries("Series B");
        Task taskB2 = new Task("Task 2", new SimpleTimePeriod(new Date(2220L), new Date(3350L)));
        taskB2.setPercentComplete(0.3);
        taskB2.addSubtask(sub4);
        taskB2.addSubtask(sub5);
        taskB2.addSubtask(sub6);
        seriesB.add(taskB2);
        TaskSeriesCollection tsc = new TaskSeriesCollection();
        tsc.add(seriesA);
        tsc.add(seriesB);
        return tsc;
    }

    public void testGetSeriesCount() {
        TaskSeriesCollection c = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((int)2, (int)c.getSeriesCount());
    }

    public void testGetSeriesKey() {
        TaskSeriesCollection c = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((Object)"S1", (Object)c.getSeriesKey(0));
        TaskSeriesCollectionTests.assertEquals((Object)"S2", (Object)c.getSeriesKey(1));
    }

    public void testGetRowCount() {
        TaskSeriesCollection c = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((int)2, (int)c.getRowCount());
    }

    public void testGetRowKey() {
        TaskSeriesCollection c = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((Object)"S1", (Object)c.getRowKey(0));
        TaskSeriesCollectionTests.assertEquals((Object)"S2", (Object)c.getRowKey(1));
    }

    public void testGetRowIndex() {
        TaskSeriesCollection c = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((int)0, (int)c.getRowIndex((Comparable)((Object)"S1")));
        TaskSeriesCollectionTests.assertEquals((int)1, (int)c.getRowIndex((Comparable)((Object)"S2")));
    }

    public void testGetValue() {
        TaskSeriesCollection c = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((Object)new Long(1L), (Object)c.getValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 1")));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(3L), (Object)c.getValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 2")));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(5L), (Object)c.getValue((Comparable)((Object)"S2"), (Comparable)((Object)"Task 3")));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(1L), (Object)c.getValue(0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(3L), (Object)c.getValue(0, 1));
        TaskSeriesCollectionTests.assertEquals(null, (Object)c.getValue(0, 2));
        TaskSeriesCollectionTests.assertEquals(null, (Object)c.getValue(1, 0));
        TaskSeriesCollectionTests.assertEquals(null, (Object)c.getValue(1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(5L), (Object)c.getValue(1, 2));
    }

    public void testGetStartValue() {
        TaskSeriesCollection c = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((Object)new Long(1L), (Object)c.getStartValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 1")));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(3L), (Object)c.getStartValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 2")));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(5L), (Object)c.getStartValue((Comparable)((Object)"S2"), (Comparable)((Object)"Task 3")));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(1L), (Object)c.getStartValue(0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(3L), (Object)c.getStartValue(0, 1));
        TaskSeriesCollectionTests.assertEquals(null, (Object)c.getStartValue(0, 2));
        TaskSeriesCollectionTests.assertEquals(null, (Object)c.getStartValue(1, 0));
        TaskSeriesCollectionTests.assertEquals(null, (Object)c.getStartValue(1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(5L), (Object)c.getStartValue(1, 2));
        TaskSeriesCollection c3 = this.createCollection3();
        TaskSeriesCollectionTests.assertEquals((Object)new Long(100L), (Object)c3.getStartValue(0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(220L), (Object)c3.getStartValue(0, 1));
        TaskSeriesCollectionTests.assertTrue((c3.getStartValue(1, 0) == null ? 1 : 0) != 0);
        TaskSeriesCollectionTests.assertEquals((Object)new Long(2220L), (Object)c3.getStartValue(1, 1));
    }

    public void testGetStartValue2() {
        TaskSeriesCollection c = this.createCollection2();
        TaskSeriesCollectionTests.assertEquals((Object)new Long(10L), (Object)c.getStartValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 1"), 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(16L), (Object)c.getStartValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 1"), 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(30L), (Object)c.getStartValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 2"), 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(36L), (Object)c.getStartValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 2"), 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(50L), (Object)c.getStartValue((Comparable)((Object)"S2"), (Comparable)((Object)"Task 3"), 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(56L), (Object)c.getStartValue((Comparable)((Object)"S2"), (Comparable)((Object)"Task 3"), 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(10L), (Object)c.getStartValue(0, 0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(16L), (Object)c.getStartValue(0, 0, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(30L), (Object)c.getStartValue(0, 1, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(36L), (Object)c.getStartValue(0, 1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(50L), (Object)c.getStartValue(1, 2, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(56L), (Object)c.getStartValue(1, 2, 1));
        TaskSeriesCollection c3 = this.createCollection3();
        TaskSeriesCollectionTests.assertEquals((Object)new Long(11L), (Object)c3.getStartValue(0, 0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(22L), (Object)c3.getStartValue(0, 1, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(33L), (Object)c3.getStartValue(0, 1, 1));
        TaskSeriesCollectionTests.assertTrue((c3.getStartValue(1, 0, 0) == null ? 1 : 0) != 0);
        TaskSeriesCollectionTests.assertEquals((Object)new Long(44L), (Object)c3.getStartValue(1, 1, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(55L), (Object)c3.getStartValue(1, 1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(66L), (Object)c3.getStartValue(1, 1, 2));
    }

    public void testGetEndValue() {
        TaskSeriesCollection c = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((Object)new Long(2L), (Object)c.getEndValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 1")));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(4L), (Object)c.getEndValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 2")));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(6L), (Object)c.getEndValue((Comparable)((Object)"S2"), (Comparable)((Object)"Task 3")));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(2L), (Object)c.getEndValue(0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(4L), (Object)c.getEndValue(0, 1));
        TaskSeriesCollectionTests.assertEquals(null, (Object)c.getEndValue(0, 2));
        TaskSeriesCollectionTests.assertEquals(null, (Object)c.getEndValue(1, 0));
        TaskSeriesCollectionTests.assertEquals(null, (Object)c.getEndValue(1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(6L), (Object)c.getEndValue(1, 2));
        TaskSeriesCollection c3 = this.createCollection3();
        TaskSeriesCollectionTests.assertEquals((Object)new Long(200L), (Object)c3.getEndValue(0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(350L), (Object)c3.getEndValue(0, 1));
        TaskSeriesCollectionTests.assertTrue((c3.getEndValue(1, 0) == null ? 1 : 0) != 0);
        TaskSeriesCollectionTests.assertEquals((Object)new Long(3350L), (Object)c3.getEndValue(1, 1));
    }

    public void testGetEndValue2() {
        TaskSeriesCollection c = this.createCollection2();
        TaskSeriesCollectionTests.assertEquals((Object)new Long(15L), (Object)c.getEndValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 1"), 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(20L), (Object)c.getEndValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 1"), 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(35L), (Object)c.getEndValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 2"), 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(40L), (Object)c.getEndValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 2"), 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(55L), (Object)c.getEndValue((Comparable)((Object)"S2"), (Comparable)((Object)"Task 3"), 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(60L), (Object)c.getEndValue((Comparable)((Object)"S2"), (Comparable)((Object)"Task 3"), 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(15L), (Object)c.getEndValue(0, 0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(20L), (Object)c.getEndValue(0, 0, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(35L), (Object)c.getEndValue(0, 1, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(40L), (Object)c.getEndValue(0, 1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(55L), (Object)c.getEndValue(1, 2, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(60L), (Object)c.getEndValue(1, 2, 1));
        TaskSeriesCollection c3 = this.createCollection3();
        TaskSeriesCollectionTests.assertEquals((Object)new Long(111L), (Object)c3.getEndValue(0, 0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(222L), (Object)c3.getEndValue(0, 1, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(333L), (Object)c3.getEndValue(0, 1, 1));
        TaskSeriesCollectionTests.assertTrue((c3.getEndValue(1, 0, 0) == null ? 1 : 0) != 0);
        TaskSeriesCollectionTests.assertEquals((Object)new Long(444L), (Object)c3.getEndValue(1, 1, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(555L), (Object)c3.getEndValue(1, 1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(666L), (Object)c3.getEndValue(1, 1, 2));
    }

    public void testGetPercentComplete() {
        TaskSeriesCollection c = this.createCollection2();
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.1), (Object)c.getPercentComplete((Comparable)((Object)"S1"), (Comparable)((Object)"Task 1")));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.2), (Object)c.getPercentComplete((Comparable)((Object)"S1"), (Comparable)((Object)"Task 2")));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.3), (Object)c.getPercentComplete((Comparable)((Object)"S2"), (Comparable)((Object)"Task 3")));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.1), (Object)c.getPercentComplete(0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.2), (Object)c.getPercentComplete(0, 1));
        TaskSeriesCollectionTests.assertEquals(null, (Object)c.getPercentComplete(0, 2));
        TaskSeriesCollectionTests.assertEquals(null, (Object)c.getPercentComplete(1, 0));
        TaskSeriesCollectionTests.assertEquals(null, (Object)c.getPercentComplete(1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.3), (Object)c.getPercentComplete(1, 2));
        TaskSeriesCollection c3 = this.createCollection3();
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.1), (Object)c3.getPercentComplete(0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.2), (Object)c3.getPercentComplete(0, 1));
        TaskSeriesCollectionTests.assertTrue((c3.getPercentComplete(1, 0) == null ? 1 : 0) != 0);
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.3), (Object)c3.getPercentComplete(1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.111), (Object)c3.getPercentComplete(0, 0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.222), (Object)c3.getPercentComplete(0, 1, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.333), (Object)c3.getPercentComplete(0, 1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.444), (Object)c3.getPercentComplete(1, 1, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.555), (Object)c3.getPercentComplete(1, 1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.666), (Object)c3.getPercentComplete(1, 1, 2));
    }

    public void testGetColumnCount() {
        TaskSeriesCollection c = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((int)3, (int)c.getColumnCount());
    }

    public void testGetColumnKey() {
        TaskSeriesCollection c = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((Object)"Task 1", (Object)c.getColumnKey(0));
        TaskSeriesCollectionTests.assertEquals((Object)"Task 2", (Object)c.getColumnKey(1));
        TaskSeriesCollectionTests.assertEquals((Object)"Task 3", (Object)c.getColumnKey(2));
    }

    public void testGetColumnIndex() {
        TaskSeriesCollection c = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((int)0, (int)c.getColumnIndex((Comparable)((Object)"Task 1")));
        TaskSeriesCollectionTests.assertEquals((int)1, (int)c.getColumnIndex((Comparable)((Object)"Task 2")));
        TaskSeriesCollectionTests.assertEquals((int)2, (int)c.getColumnIndex((Comparable)((Object)"Task 3")));
    }

    public void testEquals() {
        TaskSeries s1 = new TaskSeries("S");
        s1.add(new Task("T1", new Date(1L), new Date(2L)));
        s1.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeries s2 = new TaskSeries("S");
        s2.add(new Task("T1", new Date(1L), new Date(2L)));
        s2.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeriesCollection c1 = new TaskSeriesCollection();
        c1.add(s1);
        c1.add(s2);
        TaskSeries s1b = new TaskSeries("S");
        s1b.add(new Task("T1", new Date(1L), new Date(2L)));
        s1b.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeries s2b = new TaskSeries("S");
        s2b.add(new Task("T1", new Date(1L), new Date(2L)));
        s2b.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeriesCollection c2 = new TaskSeriesCollection();
        c2.add(s1b);
        c2.add(s2b);
        TaskSeriesCollectionTests.assertTrue((boolean)c1.equals(c2));
        TaskSeriesCollectionTests.assertTrue((boolean)c2.equals(c1));
    }

    public void testCloning() {
        TaskSeries s1 = new TaskSeries("S");
        s1.add(new Task("T1", new Date(1L), new Date(2L)));
        s1.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeries s2 = new TaskSeries("S");
        s2.add(new Task("T1", new Date(1L), new Date(2L)));
        s2.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeriesCollection c1 = new TaskSeriesCollection();
        c1.add(s1);
        c1.add(s2);
        TaskSeriesCollection c2 = null;
        try {
            c2 = (TaskSeriesCollection)c1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        TaskSeriesCollectionTests.assertTrue((c1 != c2 ? 1 : 0) != 0);
        TaskSeriesCollectionTests.assertTrue((c1.getClass() == c2.getClass() ? 1 : 0) != 0);
        TaskSeriesCollectionTests.assertTrue((boolean)c1.equals(c2));
    }

    public void testSerialization() {
        TaskSeries s1 = new TaskSeries("S");
        s1.add(new Task("T1", new Date(1L), new Date(2L)));
        s1.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeries s2 = new TaskSeries("S");
        s2.add(new Task("T1", new Date(1L), new Date(2L)));
        s2.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeriesCollection c1 = new TaskSeriesCollection();
        c1.add(s1);
        c1.add(s2);
        TaskSeriesCollection c2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(c1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            c2 = (TaskSeriesCollection)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        TaskSeriesCollectionTests.assertEquals((Object)c1, c2);
    }

    public void test697153() {
        TaskSeries s1 = new TaskSeries("S1");
        s1.add(new Task("Task 1", new SimpleTimePeriod(new Date(), new Date())));
        s1.add(new Task("Task 2", new SimpleTimePeriod(new Date(), new Date())));
        s1.add(new Task("Task 3", new SimpleTimePeriod(new Date(), new Date())));
        TaskSeries s2 = new TaskSeries("S2");
        s2.add(new Task("Task 2", new SimpleTimePeriod(new Date(), new Date())));
        s2.add(new Task("Task 3", new SimpleTimePeriod(new Date(), new Date())));
        s2.add(new Task("Task 4", new SimpleTimePeriod(new Date(), new Date())));
        TaskSeriesCollection tsc = new TaskSeriesCollection();
        tsc.add(s1);
        tsc.add(s2);
        s1.removeAll();
        int taskCount = tsc.getColumnCount();
        TaskSeriesCollectionTests.assertEquals((int)3, (int)taskCount);
    }

    public void test800324() {
        TaskSeries s1 = new TaskSeries("S1");
        s1.add(new Task("Task 1", new SimpleTimePeriod(new Date(), new Date())));
        s1.add(new Task("Task 2", new SimpleTimePeriod(new Date(), new Date())));
        s1.add(new Task("Task 3", new SimpleTimePeriod(new Date(), new Date())));
        TaskSeriesCollection tsc = new TaskSeriesCollection();
        tsc.add(s1);
        try {
            tsc.getStartValue(0, 3);
            TaskSeriesCollectionTests.assertTrue((boolean)false);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            tsc.getEndValue(0, 3);
            TaskSeriesCollectionTests.assertTrue((boolean)false);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            tsc.getSubIntervalCount(0, 3);
            TaskSeriesCollectionTests.assertTrue((boolean)false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testGetSubIntervalCount() {
        TaskSeriesCollection tsc = this.createCollection3();
        TaskSeriesCollectionTests.assertEquals((int)1, (int)tsc.getSubIntervalCount(0, 0));
        TaskSeriesCollectionTests.assertEquals((int)2, (int)tsc.getSubIntervalCount(0, 1));
        TaskSeriesCollectionTests.assertEquals((int)0, (int)tsc.getSubIntervalCount(1, 0));
        TaskSeriesCollectionTests.assertEquals((int)3, (int)tsc.getSubIntervalCount(1, 1));
    }
}

