/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.category.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.KeyToGroupMap;

public class KeyToGroupMapTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(KeyToGroupMapTests.class);
    }

    public KeyToGroupMapTests(String name) {
        super(name);
    }

    public void testMapKeyToGroup() {
        KeyToGroupMap m1 = new KeyToGroupMap((Comparable)((Object)"G1"));
        m1.mapKeyToGroup((Comparable)((Object)"K1"), (Comparable)((Object)"G1"));
        KeyToGroupMapTests.assertEquals((Object)"G1", (Object)m1.getGroup((Comparable)((Object)"K1")));
        m1.mapKeyToGroup((Comparable)((Object)"K2"), (Comparable)((Object)"G2"));
        KeyToGroupMapTests.assertEquals((Object)"G2", (Object)m1.getGroup((Comparable)((Object)"K2")));
        m1.mapKeyToGroup((Comparable)((Object)"K2"), null);
        KeyToGroupMapTests.assertEquals((Object)"G1", (Object)m1.getGroup((Comparable)((Object)"K2")));
        boolean pass = false;
        try {
            m1.mapKeyToGroup(null, (Comparable)((Object)"G1"));
        }
        catch (IllegalArgumentException e) {
            pass = true;
        }
        KeyToGroupMapTests.assertTrue((boolean)pass);
    }

    public void testGroupCount() {
        KeyToGroupMap m1 = new KeyToGroupMap((Comparable)((Object)"Default Group"));
        KeyToGroupMapTests.assertEquals((int)1, (int)m1.getGroupCount());
        m1.mapKeyToGroup((Comparable)((Object)"C1"), (Comparable)((Object)"G1"));
        KeyToGroupMapTests.assertEquals((int)2, (int)m1.getGroupCount());
        m1.mapKeyToGroup((Comparable)((Object)"C2"), (Comparable)((Object)"Default Group"));
        KeyToGroupMapTests.assertEquals((int)2, (int)m1.getGroupCount());
        m1.mapKeyToGroup((Comparable)((Object)"C3"), (Comparable)((Object)"Default Group"));
        m1.mapKeyToGroup((Comparable)((Object)"C4"), (Comparable)((Object)"G2"));
        m1.mapKeyToGroup((Comparable)((Object)"C5"), (Comparable)((Object)"G2"));
        m1.mapKeyToGroup((Comparable)((Object)"C6"), (Comparable)((Object)"Default Group"));
        KeyToGroupMapTests.assertEquals((int)3, (int)m1.getGroupCount());
        m1.mapKeyToGroup((Comparable)((Object)"C4"), (Comparable)((Object)"G1"));
        m1.mapKeyToGroup((Comparable)((Object)"C5"), (Comparable)((Object)"G1"));
        KeyToGroupMapTests.assertEquals((int)2, (int)m1.getGroupCount());
    }

    public void testKeyCount() {
        KeyToGroupMap m1 = new KeyToGroupMap((Comparable)((Object)"Default Group"));
        KeyToGroupMapTests.assertEquals((int)0, (int)m1.getKeyCount((Comparable)((Object)"Default Group")));
        m1.mapKeyToGroup((Comparable)((Object)"K1"), (Comparable)((Object)"G1"));
        KeyToGroupMapTests.assertEquals((int)1, (int)m1.getKeyCount((Comparable)((Object)"G1")));
        m1.mapKeyToGroup((Comparable)((Object)"K1"), null);
        KeyToGroupMapTests.assertEquals((int)0, (int)m1.getKeyCount((Comparable)((Object)"G1")));
        m1.mapKeyToGroup((Comparable)((Object)"K2"), (Comparable)((Object)"Default Group"));
        KeyToGroupMapTests.assertEquals((int)1, (int)m1.getKeyCount((Comparable)((Object)"Default Group")));
        m1.mapKeyToGroup((Comparable)((Object)"K3"), (Comparable)((Object)"Default Group"));
        m1.mapKeyToGroup((Comparable)((Object)"K4"), (Comparable)((Object)"G2"));
        m1.mapKeyToGroup((Comparable)((Object)"K5"), (Comparable)((Object)"G2"));
        m1.mapKeyToGroup((Comparable)((Object)"K6"), (Comparable)((Object)"Default Group"));
        KeyToGroupMapTests.assertEquals((int)3, (int)m1.getKeyCount((Comparable)((Object)"Default Group")));
        KeyToGroupMapTests.assertEquals((int)2, (int)m1.getKeyCount((Comparable)((Object)"G2")));
        m1.mapKeyToGroup((Comparable)((Object)"K4"), (Comparable)((Object)"G1"));
        m1.mapKeyToGroup((Comparable)((Object)"K5"), (Comparable)((Object)"G1"));
        KeyToGroupMapTests.assertEquals((int)2, (int)m1.getKeyCount((Comparable)((Object)"G1")));
        KeyToGroupMapTests.assertEquals((int)0, (int)m1.getKeyCount((Comparable)((Object)"G2")));
    }

    public void testGetGroupIndex() {
        KeyToGroupMap m1 = new KeyToGroupMap((Comparable)((Object)"Default Group"));
        KeyToGroupMapTests.assertEquals((int)0, (int)m1.getGroupIndex((Comparable)((Object)"Default Group")));
        KeyToGroupMapTests.assertEquals((int)-1, (int)m1.getGroupIndex((Comparable)((Object)"G3")));
        m1.mapKeyToGroup((Comparable)((Object)"K3"), (Comparable)((Object)"G3"));
        m1.mapKeyToGroup((Comparable)((Object)"K1"), (Comparable)((Object)"G1"));
        m1.mapKeyToGroup((Comparable)((Object)"K2"), (Comparable)((Object)"G2"));
        KeyToGroupMapTests.assertEquals((int)1, (int)m1.getGroupIndex((Comparable)((Object)"G3")));
        KeyToGroupMapTests.assertEquals((int)2, (int)m1.getGroupIndex((Comparable)((Object)"G1")));
        KeyToGroupMapTests.assertEquals((int)3, (int)m1.getGroupIndex((Comparable)((Object)"G2")));
    }

    public void testGetGroup() {
        KeyToGroupMap m1 = new KeyToGroupMap((Comparable)((Object)"Default Group"));
        KeyToGroupMapTests.assertEquals((Object)"Default Group", (Object)m1.getGroup((Comparable)((Object)"K1")));
        m1.mapKeyToGroup((Comparable)((Object)"K1"), (Comparable)((Object)"G1"));
        KeyToGroupMapTests.assertEquals((Object)"G1", (Object)m1.getGroup((Comparable)((Object)"K1")));
        m1.mapKeyToGroup((Comparable)((Object)"K1"), (Comparable)((Object)"G2"));
        KeyToGroupMapTests.assertEquals((Object)"G2", (Object)m1.getGroup((Comparable)((Object)"K1")));
        m1.mapKeyToGroup((Comparable)((Object)"K1"), null);
        KeyToGroupMapTests.assertEquals((Object)"Default Group", (Object)m1.getGroup((Comparable)((Object)"K1")));
        boolean pass = false;
        try {
            Comparable g = m1.getGroup(null);
            System.out.println(g);
        }
        catch (IllegalArgumentException e) {
            pass = true;
        }
        KeyToGroupMapTests.assertTrue((boolean)pass);
    }

    public void testEquals() {
        KeyToGroupMap m1 = new KeyToGroupMap((Comparable)((Object)"Default Group"));
        KeyToGroupMap m2 = new KeyToGroupMap((Comparable)((Object)"Default Group"));
        KeyToGroupMapTests.assertTrue((boolean)m1.equals(m2));
        KeyToGroupMapTests.assertTrue((boolean)m2.equals(m1));
        m1.mapKeyToGroup((Comparable)((Object)"K1"), (Comparable)((Object)"G1"));
        KeyToGroupMapTests.assertFalse((boolean)m1.equals(m2));
        m2.mapKeyToGroup((Comparable)((Object)"K1"), (Comparable)((Object)"G1"));
        KeyToGroupMapTests.assertTrue((boolean)m1.equals(m2));
    }

    public void testCloning() {
        KeyToGroupMap m1 = new KeyToGroupMap((Comparable)((Object)"Test"));
        m1.mapKeyToGroup((Comparable)((Object)"K1"), (Comparable)((Object)"G1"));
        KeyToGroupMap m2 = null;
        try {
            m2 = (KeyToGroupMap)m1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        KeyToGroupMapTests.assertTrue((m1 != m2 ? 1 : 0) != 0);
        KeyToGroupMapTests.assertTrue((m1.getClass() == m2.getClass() ? 1 : 0) != 0);
        KeyToGroupMapTests.assertTrue((boolean)m1.equals(m2));
        m1.mapKeyToGroup((Comparable)((Object)"K1"), (Comparable)((Object)"G2"));
        KeyToGroupMapTests.assertFalse((boolean)m1.equals(m2));
        m2.mapKeyToGroup((Comparable)((Object)"K1"), (Comparable)((Object)"G2"));
        KeyToGroupMapTests.assertTrue((boolean)m1.equals(m2));
    }

    public void testSerialization() {
        KeyToGroupMap m1 = new KeyToGroupMap((Comparable)((Object)"Test"));
        KeyToGroupMap m2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(m1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            m2 = (KeyToGroupMap)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        KeyToGroupMapTests.assertEquals((Object)m1, m2);
    }
}

