/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.category.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.category.DefaultCategoryDataset;

public class DefaultCategoryDatasetTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DefaultCategoryDatasetTests.class);
    }

    public DefaultCategoryDatasetTests(String name) {
        super(name);
    }

    public void testGetRowCount() {
        DefaultCategoryDataset d = new DefaultCategoryDataset();
        DefaultCategoryDatasetTests.assertTrue((d.getRowCount() == 0 ? 1 : 0) != 0);
        d.addValue(1.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        DefaultCategoryDatasetTests.assertTrue((d.getRowCount() == 1 ? 1 : 0) != 0);
        d.addValue(1.0, (Comparable)((Object)"R2"), (Comparable)((Object)"C1"));
        DefaultCategoryDatasetTests.assertTrue((d.getRowCount() == 2 ? 1 : 0) != 0);
        d.addValue(2.0, (Comparable)((Object)"R2"), (Comparable)((Object)"C1"));
        DefaultCategoryDatasetTests.assertTrue((d.getRowCount() == 2 ? 1 : 0) != 0);
        d.setValue(null, (Comparable)((Object)"R2"), (Comparable)((Object)"C1"));
        DefaultCategoryDatasetTests.assertTrue((d.getRowCount() == 2 ? 1 : 0) != 0);
    }

    public void testGetColumnCount() {
        DefaultCategoryDataset d = new DefaultCategoryDataset();
        DefaultCategoryDatasetTests.assertTrue((d.getColumnCount() == 0 ? 1 : 0) != 0);
        d.addValue(1.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        DefaultCategoryDatasetTests.assertTrue((d.getColumnCount() == 1 ? 1 : 0) != 0);
        d.addValue(1.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C2"));
        DefaultCategoryDatasetTests.assertTrue((d.getColumnCount() == 2 ? 1 : 0) != 0);
        d.addValue(2.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C2"));
        DefaultCategoryDatasetTests.assertTrue((d.getColumnCount() == 2 ? 1 : 0) != 0);
        d.setValue(null, (Comparable)((Object)"R1"), (Comparable)((Object)"C2"));
        DefaultCategoryDatasetTests.assertTrue((d.getColumnCount() == 2 ? 1 : 0) != 0);
    }

    public void testEquals() {
        DefaultCategoryDataset d1 = new DefaultCategoryDataset();
        d1.setValue(23.4, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        DefaultCategoryDataset d2 = new DefaultCategoryDataset();
        d2.setValue(23.4, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        DefaultCategoryDatasetTests.assertTrue((boolean)d1.equals(d2));
        DefaultCategoryDatasetTests.assertTrue((boolean)d2.equals(d1));
        d1.setValue(36.5, (Comparable)((Object)"R1"), (Comparable)((Object)"C2"));
        DefaultCategoryDatasetTests.assertFalse((boolean)d1.equals(d2));
        d2.setValue(36.5, (Comparable)((Object)"R1"), (Comparable)((Object)"C2"));
        DefaultCategoryDatasetTests.assertTrue((boolean)d1.equals(d2));
        d1.setValue(null, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        DefaultCategoryDatasetTests.assertFalse((boolean)d1.equals(d2));
        d2.setValue(null, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        DefaultCategoryDatasetTests.assertTrue((boolean)d1.equals(d2));
    }

    public void testSerialization() {
        DefaultCategoryDataset d1 = new DefaultCategoryDataset();
        d1.setValue(23.4, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        DefaultCategoryDataset d2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(d1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            d2 = (DefaultCategoryDataset)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        DefaultCategoryDatasetTests.assertEquals((Object)d1, d2);
    }
}

