/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title.junit;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;

public class LegendTitleTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(LegendTitleTests.class);
    }

    public LegendTitleTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYPlot plot1 = new XYPlot();
        LegendTitle t1 = new LegendTitle(plot1);
        LegendTitle t2 = new LegendTitle(plot1);
        LegendTitleTests.assertEquals((Object)t1, (Object)t2);
        t1.setBackgroundPaint(new GradientPaint(1.0f, 2.0f, Color.red, 3.0f, 4.0f, Color.yellow));
        LegendTitleTests.assertFalse((boolean)t1.equals(t2));
        t2.setBackgroundPaint(new GradientPaint(1.0f, 2.0f, Color.red, 3.0f, 4.0f, Color.yellow));
        LegendTitleTests.assertTrue((boolean)t1.equals(t2));
        t1.setLegendItemGraphicEdge(RectangleEdge.BOTTOM);
        LegendTitleTests.assertFalse((boolean)t1.equals(t2));
        t2.setLegendItemGraphicEdge(RectangleEdge.BOTTOM);
        LegendTitleTests.assertTrue((boolean)t1.equals(t2));
        t1.setLegendItemGraphicAnchor(RectangleAnchor.BOTTOM_LEFT);
        LegendTitleTests.assertFalse((boolean)t1.equals(t2));
        t2.setLegendItemGraphicAnchor(RectangleAnchor.BOTTOM_LEFT);
        LegendTitleTests.assertTrue((boolean)t1.equals(t2));
        t1.setLegendItemGraphicLocation(RectangleAnchor.TOP_LEFT);
        LegendTitleTests.assertFalse((boolean)t1.equals(t2));
        t2.setLegendItemGraphicLocation(RectangleAnchor.TOP_LEFT);
        LegendTitleTests.assertTrue((boolean)t1.equals(t2));
        t1.setItemFont(new Font("Dialog", 0, 19));
        LegendTitleTests.assertFalse((boolean)t1.equals(t2));
        t2.setItemFont(new Font("Dialog", 0, 19));
        LegendTitleTests.assertTrue((boolean)t1.equals(t2));
    }

    public void testHashcode() {
        XYPlot plot1 = new XYPlot();
        LegendTitle t1 = new LegendTitle(plot1);
        LegendTitle t2 = new LegendTitle(plot1);
        LegendTitleTests.assertTrue((boolean)t1.equals(t2));
        int h1 = t1.hashCode();
        int h2 = t2.hashCode();
        LegendTitleTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        XYPlot plot = new XYPlot();
        LegendTitle t1 = new LegendTitle(plot);
        t1.setBackgroundPaint(new GradientPaint(1.0f, 2.0f, Color.red, 3.0f, 4.0f, Color.yellow));
        LegendTitle t2 = null;
        try {
            t2 = (LegendTitle)t1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        LegendTitleTests.assertTrue((t1 != t2 ? 1 : 0) != 0);
        LegendTitleTests.assertTrue((t1.getClass() == t2.getClass() ? 1 : 0) != 0);
        LegendTitleTests.assertTrue((boolean)t1.equals(t2));
    }

    public void testSerialization() {
        XYPlot plot = new XYPlot();
        LegendTitle t1 = new LegendTitle(plot);
        LegendTitle t2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(t1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            t2 = (LegendTitle)in.readObject();
            in.close();
        }
        catch (Exception e) {
            LegendTitleTests.fail((String)e.toString());
        }
        LegendTitleTests.assertTrue((boolean)t1.equals(t2));
    }
}

