/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.xy.XYStepRenderer;

public class XYStepRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYStepRendererTests.class);
    }

    public XYStepRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYStepRenderer r1 = new XYStepRenderer();
        XYStepRenderer r2 = new XYStepRenderer();
        XYStepRendererTests.assertEquals((Object)r1, (Object)r2);
    }

    public void testHashcode() {
        XYStepRenderer r1 = new XYStepRenderer();
        XYStepRenderer r2 = new XYStepRenderer();
        XYStepRendererTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        XYStepRendererTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        XYStepRenderer r1 = new XYStepRenderer();
        XYStepRenderer r2 = null;
        try {
            r2 = (XYStepRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        XYStepRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        XYStepRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        XYStepRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        XYStepRenderer r1 = new XYStepRenderer();
        XYStepRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (XYStepRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        XYStepRendererTests.assertEquals((Object)r1, r2);
    }
}

