/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.awt.geom.Line2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.junit.RendererXYPackageTests;
import org.jfree.data.Range;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYSeriesCollection;

public class XYLineAndShapeRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYLineAndShapeRendererTests.class);
    }

    public XYLineAndShapeRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYLineAndShapeRenderer r1 = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer r2 = new XYLineAndShapeRenderer();
        XYLineAndShapeRendererTests.assertEquals((Object)r1, (Object)r2);
        XYLineAndShapeRendererTests.assertEquals((Object)r2, (Object)r1);
        r1.setLinesVisible(true);
        XYLineAndShapeRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setLinesVisible(true);
        XYLineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setSeriesLinesVisible(3, true);
        XYLineAndShapeRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setSeriesLinesVisible(3, true);
        XYLineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setDefaultLinesVisible(false);
        XYLineAndShapeRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setDefaultLinesVisible(false);
        XYLineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setLegendLine(new Line2D.Double(1.0, 2.0, 3.0, 4.0));
        XYLineAndShapeRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setLegendLine(new Line2D.Double(1.0, 2.0, 3.0, 4.0));
        XYLineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setShapesVisible(true);
        XYLineAndShapeRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setShapesVisible(true);
        XYLineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setSeriesShapesVisible(3, true);
        XYLineAndShapeRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setSeriesShapesVisible(3, true);
        XYLineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setDefaultShapesVisible(false);
        XYLineAndShapeRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setDefaultShapesVisible(false);
        XYLineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setShapesFilled(true);
        XYLineAndShapeRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setShapesFilled(true);
        XYLineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setSeriesShapesFilled(3, true);
        XYLineAndShapeRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setSeriesShapesFilled(3, true);
        XYLineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setDefaultShapesFilled(false);
        XYLineAndShapeRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setDefaultShapesFilled(false);
        XYLineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setDrawOutlines(!r1.getDrawOutlines());
        XYLineAndShapeRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setDrawOutlines(r1.getDrawOutlines());
        XYLineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setUseOutlinePaint(true);
        XYLineAndShapeRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setUseOutlinePaint(true);
        XYLineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testHashcode() {
        XYLineAndShapeRenderer r1 = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer r2 = new XYLineAndShapeRenderer();
        XYLineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        XYLineAndShapeRendererTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        XYLineAndShapeRenderer r1 = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer r2 = null;
        try {
            r2 = (XYLineAndShapeRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        XYLineAndShapeRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        XYLineAndShapeRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        XYLineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        XYLineAndShapeRenderer r1 = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (XYLineAndShapeRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        XYLineAndShapeRendererTests.assertEquals((Object)r1, r2);
    }

    public void testFindDomainBounds() {
        XYSeriesCollection dataset = RendererXYPackageTests.createTestXYSeriesCollection();
        JFreeChart chart = ChartFactory.createXYLineChart("Test Chart", "X", "Y", dataset, PlotOrientation.VERTICAL, false, false, false);
        XYPlot plot = (XYPlot)chart.getPlot();
        NumberAxis domainAxis = (NumberAxis)plot.getDomainAxis();
        domainAxis.setAutoRangeIncludesZero(false);
        Range bounds = domainAxis.getRange();
        XYLineAndShapeRendererTests.assertFalse((boolean)bounds.contains(0.9));
        XYLineAndShapeRendererTests.assertTrue((boolean)bounds.contains(1.0));
        XYLineAndShapeRendererTests.assertTrue((boolean)bounds.contains(2.0));
        XYLineAndShapeRendererTests.assertFalse((boolean)bounds.contains(2.1));
    }

    public void testFindRangeBounds() {
        TableXYDataset dataset = RendererXYPackageTests.createTestTableXYDataset();
        JFreeChart chart = ChartFactory.createXYLineChart("Test Chart", "X", "Y", dataset, PlotOrientation.VERTICAL, false, false, false);
        XYPlot plot = (XYPlot)chart.getPlot();
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setAutoRangeIncludesZero(false);
        Range bounds = rangeAxis.getRange();
        XYLineAndShapeRendererTests.assertFalse((boolean)bounds.contains(1.0));
        XYLineAndShapeRendererTests.assertTrue((boolean)bounds.contains(2.0));
        XYLineAndShapeRendererTests.assertTrue((boolean)bounds.contains(5.0));
        XYLineAndShapeRendererTests.assertFalse((boolean)bounds.contains(6.0));
    }
}

