/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.awt.Color;
import java.awt.geom.Line2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;

public class XYDifferenceRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYDifferenceRendererTests.class);
    }

    public XYDifferenceRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYDifferenceRenderer r1 = new XYDifferenceRenderer(Color.red, Color.blue, false);
        XYDifferenceRenderer r2 = new XYDifferenceRenderer(Color.red, Color.blue, false);
        XYDifferenceRendererTests.assertEquals((Object)r1, (Object)r2);
        r1 = new XYDifferenceRenderer(Color.green, Color.blue, false);
        XYDifferenceRendererTests.assertFalse((boolean)r1.equals(r2));
        r2 = new XYDifferenceRenderer(Color.green, Color.blue, false);
        XYDifferenceRendererTests.assertTrue((boolean)r1.equals(r2));
        r1 = new XYDifferenceRenderer(Color.green, Color.yellow, false);
        XYDifferenceRendererTests.assertFalse((boolean)r1.equals(r2));
        r2 = new XYDifferenceRenderer(Color.green, Color.yellow, false);
        XYDifferenceRendererTests.assertTrue((boolean)r1.equals(r2));
        r1 = new XYDifferenceRenderer(Color.green, Color.yellow, true);
        XYDifferenceRendererTests.assertFalse((boolean)r1.equals(r2));
        r2 = new XYDifferenceRenderer(Color.green, Color.yellow, true);
        XYDifferenceRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setLegendLine(new Line2D.Double(1.0, 2.0, 3.0, 4.0));
        XYDifferenceRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setLegendLine(new Line2D.Double(1.0, 2.0, 3.0, 4.0));
        XYDifferenceRendererTests.assertTrue((boolean)r1.equals(r2));
        XYDifferenceRendererTests.assertFalse((boolean)r1.equals(null));
    }

    public void testHashcode() {
        XYDifferenceRenderer r1 = new XYDifferenceRenderer(Color.red, Color.blue, false);
        XYDifferenceRenderer r2 = new XYDifferenceRenderer(Color.red, Color.blue, false);
        XYDifferenceRendererTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        XYDifferenceRendererTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        XYDifferenceRenderer r1 = new XYDifferenceRenderer(Color.red, Color.blue, false);
        XYDifferenceRenderer r2 = null;
        try {
            r2 = (XYDifferenceRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        XYDifferenceRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        XYDifferenceRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        XYDifferenceRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        XYDifferenceRenderer r1 = new XYDifferenceRenderer(Color.red, Color.blue, false);
        XYDifferenceRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (XYDifferenceRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        XYDifferenceRendererTests.assertEquals((Object)r1, r2);
    }
}

