/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.xy.XYBoxAndWhiskerRenderer;

public class XYBoxAndWhiskerRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYBoxAndWhiskerRendererTests.class);
    }

    public XYBoxAndWhiskerRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYBoxAndWhiskerRenderer r1 = new XYBoxAndWhiskerRenderer();
        XYBoxAndWhiskerRenderer r2 = new XYBoxAndWhiskerRenderer();
        XYBoxAndWhiskerRendererTests.assertEquals((Object)r1, (Object)r2);
        r1.setPaint(Color.yellow);
        XYBoxAndWhiskerRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setPaint(Color.yellow);
        XYBoxAndWhiskerRendererTests.assertEquals((Object)r1, (Object)r2);
        r1.setArtifactPaint(Color.yellow);
        XYBoxAndWhiskerRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setArtifactPaint(Color.yellow);
        XYBoxAndWhiskerRendererTests.assertEquals((Object)r1, (Object)r2);
        r1.setBoxWidth(0.55);
        XYBoxAndWhiskerRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setBoxWidth(0.55);
        XYBoxAndWhiskerRendererTests.assertEquals((Object)r1, (Object)r2);
        r1.setFillBox(!r1.getFillBox());
        XYBoxAndWhiskerRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setFillBox(!r2.getFillBox());
        XYBoxAndWhiskerRendererTests.assertEquals((Object)r1, (Object)r2);
    }

    public void testHashcode() {
        XYBoxAndWhiskerRenderer r1 = new XYBoxAndWhiskerRenderer();
        XYBoxAndWhiskerRenderer r2 = new XYBoxAndWhiskerRenderer();
        XYBoxAndWhiskerRendererTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        XYBoxAndWhiskerRendererTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        XYBoxAndWhiskerRenderer r1 = new XYBoxAndWhiskerRenderer();
        XYBoxAndWhiskerRenderer r2 = null;
        try {
            r2 = (XYBoxAndWhiskerRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        XYBoxAndWhiskerRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        XYBoxAndWhiskerRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        XYBoxAndWhiskerRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        XYBoxAndWhiskerRenderer r1 = new XYBoxAndWhiskerRenderer();
        XYBoxAndWhiskerRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (XYBoxAndWhiskerRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        XYBoxAndWhiskerRendererTests.assertEquals((Object)r1, r2);
    }
}

