/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer;
import org.jfree.chart.renderer.xy.junit.RendererXYPackageTests;
import org.jfree.data.Range;
import org.jfree.data.xy.TableXYDataset;

public class StackedXYAreaRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StackedXYAreaRendererTests.class);
    }

    public StackedXYAreaRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        StackedXYAreaRenderer r1 = new StackedXYAreaRenderer();
        StackedXYAreaRenderer r2 = new StackedXYAreaRenderer();
        StackedXYAreaRendererTests.assertEquals((Object)r1, (Object)r2);
        StackedXYAreaRendererTests.assertEquals((Object)r2, (Object)r1);
        r1.setShapePaint(Color.yellow);
        StackedXYAreaRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setShapePaint(Color.yellow);
        StackedXYAreaRendererTests.assertTrue((boolean)r1.equals(r2));
        BasicStroke s = new BasicStroke(1.23f);
        r1.setShapeStroke(s);
        StackedXYAreaRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setShapeStroke(s);
        StackedXYAreaRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testHashcode() {
        StackedXYAreaRenderer r1 = new StackedXYAreaRenderer();
        StackedXYAreaRenderer r2 = new StackedXYAreaRenderer();
        StackedXYAreaRendererTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        StackedXYAreaRendererTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        StackedXYAreaRenderer r1 = new StackedXYAreaRenderer();
        StackedXYAreaRenderer r2 = null;
        try {
            r2 = (StackedXYAreaRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        StackedXYAreaRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        StackedXYAreaRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        StackedXYAreaRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        StackedXYAreaRenderer r1 = new StackedXYAreaRenderer();
        StackedXYAreaRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (StackedXYAreaRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        StackedXYAreaRendererTests.assertEquals((Object)r1, r2);
    }

    public void testFindRangeBounds() {
        TableXYDataset dataset = RendererXYPackageTests.createTestTableXYDataset();
        JFreeChart chart = ChartFactory.createStackedXYAreaChart("Test Chart", "X", "Y", dataset, PlotOrientation.VERTICAL, false, false, false);
        XYPlot plot = (XYPlot)chart.getPlot();
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        Range bounds = rangeAxis.getRange();
        StackedXYAreaRendererTests.assertTrue((boolean)bounds.contains(6.0));
        StackedXYAreaRendererTests.assertTrue((boolean)bounds.contains(8.0));
    }
}

