/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.junit.RendererChangeDetector;
import org.jfree.ui.TextAnchor;

public class AbstractRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(AbstractRendererTests.class);
    }

    public AbstractRendererTests(String name) {
        super(name);
    }

    public void testSetSeriesVisible() {
        BarRenderer r = new BarRenderer();
        r.setSeriesVisible(Boolean.TRUE);
        AbstractRendererTests.assertTrue((boolean)r.getItemVisible(0, 0));
    }

    public void testSetPaint() {
        BarRenderer r = new BarRenderer();
        r.setPaint(Color.orange);
        AbstractRendererTests.assertEquals((Object)Color.orange, (Object)r.getItemPaint(0, 0));
    }

    public void testSetOutlinePaint() {
        BarRenderer r = new BarRenderer();
        r.setOutlinePaint(Color.orange);
        AbstractRendererTests.assertEquals((Object)Color.orange, (Object)r.getItemOutlinePaint(0, 0));
    }

    public void testSetStroke() {
        BarRenderer r = new BarRenderer();
        BasicStroke s = new BasicStroke(10.0f);
        r.setStroke(s);
        AbstractRendererTests.assertEquals((Object)s, (Object)r.getItemStroke(0, 0));
    }

    public void testSetOutlineStroke() {
        BarRenderer r = new BarRenderer();
        BasicStroke s = new BasicStroke(10.0f);
        r.setOutlineStroke(s);
        AbstractRendererTests.assertEquals((Object)s, (Object)r.getItemOutlineStroke(0, 0));
    }

    public void testSetShape() {
        BarRenderer r = new BarRenderer();
        Rectangle2D.Double s = new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0);
        r.setShape(s);
        AbstractRendererTests.assertEquals((Object)s, (Object)r.getItemShape(0, 0));
    }

    public void testSetItemLabelsVisible() {
        BarRenderer r = new BarRenderer();
        r.setItemLabelsVisible(true);
        AbstractRendererTests.assertTrue((boolean)r.isItemLabelVisible(0, 0));
    }

    public void testSetItemLabelFont() {
        BarRenderer r = new BarRenderer();
        r.setItemLabelFont(new Font("SansSerif", 0, 33));
        AbstractRendererTests.assertEquals((Object)new Font("SansSerif", 0, 33), (Object)r.getItemLabelFont(0, 0));
    }

    public void testSetItemLabelPaint() {
        BarRenderer r = new BarRenderer();
        r.setItemLabelPaint(Color.green);
        AbstractRendererTests.assertEquals((Object)Color.green, (Object)r.getItemLabelPaint(0, 0));
    }

    public void testSetPositiveItemLabelPosition() {
        BarRenderer r = new BarRenderer();
        r.setPositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.INSIDE1, TextAnchor.BASELINE_LEFT));
        AbstractRendererTests.assertEquals((Object)new ItemLabelPosition(ItemLabelAnchor.INSIDE1, TextAnchor.BASELINE_LEFT), (Object)r.getPositiveItemLabelPosition(0, 0));
    }

    public void testSetNegativeItemLabelPosition() {
        BarRenderer r = new BarRenderer();
        r.setNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.INSIDE1, TextAnchor.BASELINE_LEFT));
        AbstractRendererTests.assertEquals((Object)new ItemLabelPosition(ItemLabelAnchor.INSIDE1, TextAnchor.BASELINE_LEFT), (Object)r.getNegativeItemLabelPosition(0, 0));
    }

    public void testEventNotification() {
        RendererChangeDetector detector = new RendererChangeDetector();
        BarRenderer r1 = new BarRenderer();
        r1.addChangeListener(detector);
        detector.setNotified(false);
        r1.setPaint(Color.red);
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setSeriesPaint(0, Color.red);
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setBasePaint(Color.red);
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setOutlinePaint(Color.red);
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setSeriesOutlinePaint(0, Color.red);
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setBaseOutlinePaint(Color.red);
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setStroke(new BasicStroke(1.0f));
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setSeriesStroke(0, new BasicStroke(1.0f));
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setBaseStroke(new BasicStroke(1.0f));
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setOutlineStroke(new BasicStroke(1.0f));
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setSeriesOutlineStroke(0, new BasicStroke(1.0f));
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setBaseOutlineStroke(new BasicStroke(1.0f));
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setShape(new Rectangle2D.Float());
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setSeriesShape(0, new Rectangle2D.Float());
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setBaseShape(new Rectangle2D.Float());
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setItemLabelsVisible(Boolean.TRUE);
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setSeriesItemLabelsVisible(0, Boolean.TRUE);
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setBaseItemLabelsVisible(Boolean.TRUE);
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setItemLabelFont(new Font("Serif", 0, 12));
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setSeriesItemLabelFont(0, new Font("Serif", 0, 12));
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setBaseItemLabelFont(new Font("Serif", 0, 12));
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setItemLabelPaint(Color.blue);
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setSeriesItemLabelPaint(0, Color.blue);
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setBaseItemLabelPaint(Color.blue);
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setPositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setSeriesPositiveItemLabelPosition(0, new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setSeriesNegativeItemLabelPosition(0, new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setBaseNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        AbstractRendererTests.assertTrue((boolean)detector.getNotified());
    }

    public void testSerialization() {
        BarRenderer r1 = new BarRenderer();
        AbstractRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (BarRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        AbstractRendererTests.assertEquals((Object)r1, r2);
        try {
            r2.notifyListeners(new RendererChangeEvent(r2));
        }
        catch (NullPointerException e) {
            AbstractRendererTests.assertTrue((boolean)false);
        }
    }
}

