/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category.junit;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.category.WaterfallBarRenderer;

public class WaterfallBarRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(WaterfallBarRendererTests.class);
    }

    public WaterfallBarRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        WaterfallBarRenderer r1 = new WaterfallBarRenderer();
        WaterfallBarRenderer r2 = new WaterfallBarRenderer();
        WaterfallBarRendererTests.assertEquals((Object)r1, (Object)r2);
        r1.setFirstBarPaint(Color.cyan);
        WaterfallBarRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setFirstBarPaint(Color.cyan);
        WaterfallBarRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setLastBarPaint(Color.cyan);
        WaterfallBarRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setLastBarPaint(Color.cyan);
        WaterfallBarRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setPositiveBarPaint(Color.cyan);
        WaterfallBarRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setPositiveBarPaint(Color.cyan);
        WaterfallBarRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setNegativeBarPaint(Color.cyan);
        WaterfallBarRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setNegativeBarPaint(Color.cyan);
        WaterfallBarRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testHashcode() {
        WaterfallBarRenderer r1 = new WaterfallBarRenderer();
        WaterfallBarRenderer r2 = new WaterfallBarRenderer();
        WaterfallBarRendererTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        WaterfallBarRendererTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        WaterfallBarRenderer r1 = new WaterfallBarRenderer();
        WaterfallBarRenderer r2 = null;
        try {
            r2 = (WaterfallBarRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        WaterfallBarRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        WaterfallBarRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        WaterfallBarRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setFirstBarPaint(Color.yellow);
        WaterfallBarRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setFirstBarPaint(Color.yellow);
        WaterfallBarRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        WaterfallBarRenderer r1 = new WaterfallBarRenderer();
        WaterfallBarRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (WaterfallBarRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        WaterfallBarRendererTests.assertEquals((Object)r1, r2);
    }
}

