/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.category.StackedAreaRenderer;

public class StackedAreaRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StackedAreaRendererTests.class);
    }

    public StackedAreaRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        StackedAreaRenderer r1 = new StackedAreaRenderer();
        StackedAreaRenderer r2 = new StackedAreaRenderer();
        StackedAreaRendererTests.assertEquals((Object)r1, (Object)r2);
    }

    public void testHashcode() {
        StackedAreaRenderer r1 = new StackedAreaRenderer();
        StackedAreaRenderer r2 = new StackedAreaRenderer();
        StackedAreaRendererTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        StackedAreaRendererTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        StackedAreaRenderer r1 = new StackedAreaRenderer();
        StackedAreaRenderer r2 = null;
        try {
            r2 = (StackedAreaRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        StackedAreaRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        StackedAreaRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        StackedAreaRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        StackedAreaRenderer r1 = new StackedAreaRenderer();
        StackedAreaRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (StackedAreaRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        StackedAreaRendererTests.assertEquals((Object)r1, r2);
    }
}

