/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.category.GroupedStackedBarRenderer;
import org.jfree.data.KeyToGroupMap;

public class GroupedStackedBarRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(GroupedStackedBarRendererTests.class);
    }

    public GroupedStackedBarRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        GroupedStackedBarRenderer r1 = new GroupedStackedBarRenderer();
        GroupedStackedBarRenderer r2 = new GroupedStackedBarRenderer();
        GroupedStackedBarRendererTests.assertTrue((boolean)r1.equals(r2));
        GroupedStackedBarRendererTests.assertTrue((boolean)r2.equals(r1));
        KeyToGroupMap m1 = new KeyToGroupMap((Comparable)((Object)"G1"));
        m1.mapKeyToGroup((Comparable)((Object)"S1"), (Comparable)((Object)"G2"));
        r1.setSeriesToGroupMap(m1);
        GroupedStackedBarRendererTests.assertFalse((boolean)r1.equals(r2));
        KeyToGroupMap m2 = new KeyToGroupMap((Comparable)((Object)"G1"));
        m2.mapKeyToGroup((Comparable)((Object)"S1"), (Comparable)((Object)"G2"));
        r2.setSeriesToGroupMap(m2);
        GroupedStackedBarRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testCloning() {
        GroupedStackedBarRenderer r1 = new GroupedStackedBarRenderer();
        GroupedStackedBarRenderer r2 = null;
        try {
            r2 = (GroupedStackedBarRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        GroupedStackedBarRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        GroupedStackedBarRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        GroupedStackedBarRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        GroupedStackedBarRenderer r1 = new GroupedStackedBarRenderer();
        GroupedStackedBarRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (GroupedStackedBarRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        GroupedStackedBarRendererTests.assertEquals((Object)r1, r2);
    }
}

