/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.category.CategoryStepRenderer;

public class CategoryStepRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CategoryStepRendererTests.class);
    }

    public CategoryStepRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        CategoryStepRenderer r1 = new CategoryStepRenderer(false);
        CategoryStepRenderer r2 = new CategoryStepRenderer(false);
        CategoryStepRendererTests.assertEquals((Object)r1, (Object)r2);
        r1 = new CategoryStepRenderer(true);
        CategoryStepRendererTests.assertFalse((boolean)r1.equals(r2));
        r2 = new CategoryStepRenderer(true);
        CategoryStepRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testCloning() {
        CategoryStepRenderer r1 = new CategoryStepRenderer(false);
        CategoryStepRenderer r2 = null;
        try {
            r2 = (CategoryStepRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        CategoryStepRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        CategoryStepRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        CategoryStepRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        CategoryStepRenderer r1 = new CategoryStepRenderer();
        CategoryStepRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (CategoryStepRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        CategoryStepRendererTests.assertEquals((Object)r1, r2);
    }
}

