/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.category.BarRenderer3D;

public class BarRenderer3DTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(BarRenderer3DTests.class);
    }

    public BarRenderer3DTests(String name) {
        super(name);
    }

    public void testEquals() {
        BarRenderer3D r1 = new BarRenderer3D();
        BarRenderer3D r2 = new BarRenderer3D();
        BarRenderer3DTests.assertEquals((Object)r1, (Object)r2);
    }

    public void testHashcode() {
        BarRenderer3D r1 = new BarRenderer3D();
        BarRenderer3D r2 = new BarRenderer3D();
        BarRenderer3DTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        BarRenderer3DTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        BarRenderer3D r1 = new BarRenderer3D();
        BarRenderer3D r2 = null;
        try {
            r2 = (BarRenderer3D)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        BarRenderer3DTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        BarRenderer3DTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        BarRenderer3DTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        BarRenderer3D r1 = new BarRenderer3D();
        BarRenderer3D r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (BarRenderer3D)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        BarRenderer3DTests.assertEquals((Object)r1, r2);
    }
}

