/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.plot.junit.MyPlotChangeListener;
import org.jfree.chart.renderer.xy.DefaultXYItemRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleInsets;

public class XYPlotTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYPlotTests.class);
    }

    public XYPlotTests(String name) {
        super(name);
    }

    public void testGetDatasetCount() {
        XYPlot plot = new XYPlot();
        XYPlotTests.assertEquals((int)0, (int)plot.getDatasetCount());
    }

    public void testEquals() {
        XYPlot plot1 = new XYPlot();
        XYPlot plot2 = new XYPlot();
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setOrientation(PlotOrientation.HORIZONTAL);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setOrientation(PlotOrientation.HORIZONTAL);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setAxisOffset(new RectangleInsets(0.05, 0.05, 0.05, 0.05));
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setAxisOffset(new RectangleInsets(0.05, 0.05, 0.05, 0.05));
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainAxis(new NumberAxis("Domain Axis"));
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainAxis(new NumberAxis("Domain Axis"));
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainAxisLocation(AxisLocation.TOP_OR_RIGHT);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainAxisLocation(AxisLocation.TOP_OR_RIGHT);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainAxis(11, new NumberAxis("Secondary Domain Axis"));
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainAxis(11, new NumberAxis("Secondary Domain Axis"));
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeAxis(new NumberAxis("Range Axis"));
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeAxis(new NumberAxis("Range Axis"));
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeAxisLocation(AxisLocation.TOP_OR_RIGHT);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeAxisLocation(AxisLocation.TOP_OR_RIGHT);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeAxis(11, new NumberAxis("Secondary Range Axis"));
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeAxis(11, new NumberAxis("Secondary Range Axis"));
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.mapDatasetToDomainAxis(11, 11);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.mapDatasetToDomainAxis(11, 11);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.mapDatasetToRangeAxis(11, 11);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.mapDatasetToRangeAxis(11, 11);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRenderer(new DefaultXYItemRenderer());
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRenderer(new DefaultXYItemRenderer());
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRenderer(11, new DefaultXYItemRenderer());
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRenderer(11, new DefaultXYItemRenderer());
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainGridlinesVisible(false);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainGridlinesVisible(false);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        BasicStroke stroke = new BasicStroke(2.0f);
        plot1.setDomainGridlineStroke(stroke);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainGridlineStroke(stroke);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainGridlinePaint(Color.blue);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainGridlinePaint(Color.blue);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeGridlinesVisible(false);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeGridlinesVisible(false);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeGridlineStroke(stroke);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeGridlineStroke(stroke);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeGridlinePaint(Color.blue);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeGridlinePaint(Color.blue);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeZeroBaselineVisible(true);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeZeroBaselineVisible(true);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeZeroBaselineStroke(stroke);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeZeroBaselineStroke(stroke);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeZeroBaselinePaint(Color.blue);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeZeroBaselinePaint(Color.blue);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeCrosshairVisible(true);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeCrosshairVisible(true);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeCrosshairValue(100.0);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeCrosshairValue(100.0);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeCrosshairStroke(stroke);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeCrosshairStroke(stroke);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeCrosshairPaint(Color.red);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeCrosshairPaint(Color.red);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeCrosshairLockedOnData(false);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeCrosshairLockedOnData(false);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.addRangeMarker(new ValueMarker(4.0));
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.addRangeMarker(new ValueMarker(4.0));
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.addRangeMarker(1, new ValueMarker(4.0), Layer.FOREGROUND);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.addRangeMarker(1, new ValueMarker(4.0), Layer.FOREGROUND);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.addRangeMarker(1, new ValueMarker(99.0), Layer.BACKGROUND);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.addRangeMarker(1, new ValueMarker(99.0), Layer.BACKGROUND);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setWeight(3);
        XYPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setWeight(3);
        XYPlotTests.assertTrue((boolean)plot1.equals(plot2));
    }

    public void testCloning() {
        XYPlot p1 = new XYPlot();
        XYPlot p2 = null;
        try {
            p2 = (XYPlot)p1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            System.err.println("XYPlotTests.testCloning: failed to clone.");
        }
        XYPlotTests.assertTrue((p1 != p2 ? 1 : 0) != 0);
        XYPlotTests.assertTrue((p1.getClass() == p2.getClass() ? 1 : 0) != 0);
        XYPlotTests.assertTrue((boolean)p1.equals(p2));
    }

    public void testCloning2() {
        XYPlot p1 = new XYPlot(null, new NumberAxis("Domain Axis"), new NumberAxis("Range Axis"), new StandardXYItemRenderer());
        p1.setRangeAxis(1, new NumberAxis("Range Axis 2"));
        p1.setRenderer(1, new XYBarRenderer());
        XYPlot p2 = null;
        try {
            p2 = (XYPlot)p1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            System.err.println("Failed to clone.");
        }
        XYPlotTests.assertTrue((p1 != p2 ? 1 : 0) != 0);
        XYPlotTests.assertTrue((p1.getClass() == p2.getClass() ? 1 : 0) != 0);
        XYPlotTests.assertTrue((boolean)p1.equals(p2));
    }

    public void testCloneIndependence() {
        XYPlot p1 = new XYPlot(null, new NumberAxis("Domain Axis"), new NumberAxis("Range Axis"), new StandardXYItemRenderer());
        p1.setDomainAxis(1, new NumberAxis("Domain Axis 2"));
        p1.setDomainAxisLocation(1, AxisLocation.BOTTOM_OR_LEFT);
        p1.setRangeAxis(1, new NumberAxis("Range Axis 2"));
        p1.setRangeAxisLocation(1, AxisLocation.TOP_OR_RIGHT);
        p1.setRenderer(1, new XYBarRenderer());
        XYPlot p2 = null;
        try {
            p2 = (XYPlot)p1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            System.err.println("Failed to clone.");
        }
        XYPlotTests.assertTrue((boolean)p1.equals(p2));
        p1.getDomainAxis().setLabel("Label");
        XYPlotTests.assertFalse((boolean)p1.equals(p2));
        p2.getDomainAxis().setLabel("Label");
        XYPlotTests.assertTrue((boolean)p1.equals(p2));
        p1.getDomainAxis(1).setLabel("S1");
        XYPlotTests.assertFalse((boolean)p1.equals(p2));
        p2.getDomainAxis(1).setLabel("S1");
        XYPlotTests.assertTrue((boolean)p1.equals(p2));
        p1.setDomainAxisLocation(1, AxisLocation.TOP_OR_RIGHT);
        XYPlotTests.assertFalse((boolean)p1.equals(p2));
        p2.setDomainAxisLocation(1, AxisLocation.TOP_OR_RIGHT);
        XYPlotTests.assertTrue((boolean)p1.equals(p2));
        p1.mapDatasetToDomainAxis(2, 1);
        XYPlotTests.assertFalse((boolean)p1.equals(p2));
        p2.mapDatasetToDomainAxis(2, 1);
        XYPlotTests.assertTrue((boolean)p1.equals(p2));
        p1.getRangeAxis().setLabel("Label");
        XYPlotTests.assertFalse((boolean)p1.equals(p2));
        p2.getRangeAxis().setLabel("Label");
        XYPlotTests.assertTrue((boolean)p1.equals(p2));
        p1.getRangeAxis(1).setLabel("S1");
        XYPlotTests.assertFalse((boolean)p1.equals(p2));
        p2.getRangeAxis(1).setLabel("S1");
        XYPlotTests.assertTrue((boolean)p1.equals(p2));
        p1.setRangeAxisLocation(1, AxisLocation.TOP_OR_LEFT);
        XYPlotTests.assertFalse((boolean)p1.equals(p2));
        p2.setRangeAxisLocation(1, AxisLocation.TOP_OR_LEFT);
        XYPlotTests.assertTrue((boolean)p1.equals(p2));
        p1.mapDatasetToRangeAxis(2, 1);
        XYPlotTests.assertFalse((boolean)p1.equals(p2));
        p2.mapDatasetToRangeAxis(2, 1);
        XYPlotTests.assertTrue((boolean)p1.equals(p2));
        p1.getRenderer().setOutlinePaint(Color.cyan);
        XYPlotTests.assertFalse((boolean)p1.equals(p2));
        p2.getRenderer().setOutlinePaint(Color.cyan);
        XYPlotTests.assertTrue((boolean)p1.equals(p2));
        p1.getRenderer(1).setOutlinePaint(Color.red);
        XYPlotTests.assertFalse((boolean)p1.equals(p2));
        p2.getRenderer(1).setOutlinePaint(Color.red);
        XYPlotTests.assertTrue((boolean)p1.equals(p2));
    }

    public void testSetNullRenderer() {
        boolean failed = false;
        try {
            XYPlot plot = new XYPlot(null, new NumberAxis("X"), new NumberAxis("Y"), null);
            plot.setRenderer(null);
        }
        catch (Exception e) {
            failed = true;
        }
        XYPlotTests.assertTrue((!failed ? 1 : 0) != 0);
    }

    public void testSerialization1() {
        XYSeriesCollection data = new XYSeriesCollection();
        NumberAxis domainAxis = new NumberAxis("Domain");
        NumberAxis rangeAxis = new NumberAxis("Range");
        StandardXYItemRenderer renderer = new StandardXYItemRenderer();
        XYPlot p1 = new XYPlot(data, domainAxis, rangeAxis, renderer);
        XYPlot p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (XYPlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            XYPlotTests.fail((String)e.toString());
        }
        XYPlotTests.assertEquals((Object)p1, p2);
    }

    public void testSerialization2() {
        IntervalXYDataset data1 = this.createDataset1();
        XYBarRenderer renderer1 = new XYBarRenderer(0.2);
        renderer1.setToolTipGenerator(StandardXYToolTipGenerator.getTimeSeriesInstance());
        XYPlot p1 = new XYPlot(data1, new DateAxis("Date"), null, renderer1);
        XYPlot p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (XYPlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            XYPlotTests.fail((String)e.toString());
        }
        XYPlotTests.assertEquals((Object)p1, p2);
    }

    public void testSerialization3() {
        XYSeriesCollection dataset = new XYSeriesCollection();
        JFreeChart chart = ChartFactory.createXYLineChart("Test Chart", "Domain Axis", "Range Axis", dataset, PlotOrientation.VERTICAL, true, true, false);
        JFreeChart chart2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(chart);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            chart2 = (JFreeChart)in.readObject();
            in.close();
        }
        catch (Exception e) {
            XYPlotTests.fail((String)e.toString());
        }
        boolean b = chart.equals(chart2);
        System.out.println(b);
        XYPlotTests.assertEquals((Object)chart, chart2);
        boolean passed = true;
        try {
            chart2.createBufferedImage(300, 200);
        }
        catch (Exception e) {
            passed = false;
            e.printStackTrace();
        }
        XYPlotTests.assertTrue((boolean)passed);
    }

    public void testSerialization4() {
        XYSeriesCollection dataset = new XYSeriesCollection();
        JFreeChart chart = ChartFactory.createXYLineChart("Test Chart", "Domain Axis", "Range Axis", dataset, PlotOrientation.VERTICAL, true, true, false);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.addDomainMarker(new ValueMarker(1.0), Layer.FOREGROUND);
        plot.addDomainMarker(new IntervalMarker(2.0, 3.0), Layer.BACKGROUND);
        plot.addRangeMarker(new ValueMarker(4.0), Layer.FOREGROUND);
        plot.addRangeMarker(new IntervalMarker(5.0, 6.0), Layer.BACKGROUND);
        JFreeChart chart2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(chart);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            chart2 = (JFreeChart)in.readObject();
            in.close();
        }
        catch (Exception e) {
            XYPlotTests.fail((String)e.toString());
        }
        XYPlotTests.assertEquals((Object)chart, chart2);
        boolean passed = true;
        try {
            chart2.createBufferedImage(300, 200);
        }
        catch (Exception e) {
            passed = false;
            e.printStackTrace();
        }
        XYPlotTests.assertTrue((boolean)passed);
    }

    public void testSerialization5() {
        XYSeriesCollection dataset1 = new XYSeriesCollection();
        NumberAxis domainAxis1 = new NumberAxis("Domain 1");
        NumberAxis rangeAxis1 = new NumberAxis("Range 1");
        StandardXYItemRenderer renderer1 = new StandardXYItemRenderer();
        XYPlot p1 = new XYPlot(dataset1, domainAxis1, rangeAxis1, renderer1);
        NumberAxis domainAxis2 = new NumberAxis("Domain 2");
        NumberAxis rangeAxis2 = new NumberAxis("Range 2");
        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer();
        XYSeriesCollection dataset2 = new XYSeriesCollection();
        p1.setDataset(1, dataset2);
        p1.setDomainAxis(1, domainAxis2);
        p1.setRangeAxis(1, rangeAxis2);
        p1.setRenderer(1, renderer2);
        XYPlot p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (XYPlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            XYPlotTests.fail((String)e.toString());
        }
        XYPlotTests.assertEquals((Object)p1, p2);
        NumberAxis domainAxisA = (NumberAxis)p2.getDomainAxis(0);
        NumberAxis rangeAxisA = (NumberAxis)p2.getRangeAxis(0);
        XYSeriesCollection datasetA = (XYSeriesCollection)p2.getDataset(0);
        StandardXYItemRenderer rendererA = (StandardXYItemRenderer)p2.getRenderer(0);
        NumberAxis domainAxisB = (NumberAxis)p2.getDomainAxis(1);
        NumberAxis rangeAxisB = (NumberAxis)p2.getRangeAxis(1);
        XYSeriesCollection datasetB = (XYSeriesCollection)p2.getDataset(1);
        StandardXYItemRenderer rendererB = (StandardXYItemRenderer)p2.getRenderer(1);
        XYPlotTests.assertTrue((boolean)datasetA.hasListener(p2));
        XYPlotTests.assertTrue((boolean)domainAxisA.hasListener(p2));
        XYPlotTests.assertTrue((boolean)rangeAxisA.hasListener(p2));
        XYPlotTests.assertTrue((boolean)rendererA.hasListener(p2));
        XYPlotTests.assertTrue((boolean)datasetB.hasListener(p2));
        XYPlotTests.assertTrue((boolean)domainAxisB.hasListener(p2));
        XYPlotTests.assertTrue((boolean)rangeAxisB.hasListener(p2));
        XYPlotTests.assertTrue((boolean)rendererB.hasListener(p2));
    }

    public void testGetRendererForDataset() {
        XYSeriesCollection d0 = new XYSeriesCollection();
        XYSeriesCollection d1 = new XYSeriesCollection();
        XYSeriesCollection d2 = new XYSeriesCollection();
        XYSeriesCollection d3 = new XYSeriesCollection();
        XYLineAndShapeRenderer r0 = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer r2 = new XYLineAndShapeRenderer();
        XYPlot plot = new XYPlot();
        plot.setDataset(0, d0);
        plot.setDataset(1, d1);
        plot.setDataset(2, d2);
        plot.setRenderer(0, r0);
        plot.setRenderer(2, r2);
        XYPlotTests.assertEquals((Object)r0, (Object)plot.getRendererForDataset(d0));
        XYPlotTests.assertEquals((Object)r0, (Object)plot.getRendererForDataset(d1));
        XYPlotTests.assertEquals((Object)r2, (Object)plot.getRendererForDataset(d2));
        XYPlotTests.assertEquals(null, (Object)plot.getRendererForDataset(d3));
        XYPlotTests.assertEquals(null, (Object)plot.getRendererForDataset(null));
    }

    public void testGetLegendItems() {
        IntervalXYDataset d0 = this.createDataset1();
        XYDataset d1 = this.createDataset2();
        XYLineAndShapeRenderer r0 = new XYLineAndShapeRenderer();
        XYPlot plot = new XYPlot();
        plot.setDataset(0, d0);
        plot.setDataset(1, d1);
        plot.setRenderer(0, r0);
        LegendItemCollection items = plot.getLegendItems();
        XYPlotTests.assertEquals((int)2, (int)items.getItemCount());
    }

    private IntervalXYDataset createDataset1() {
        TimeSeries series1 = new TimeSeries("Series 1", Day.class);
        series1.add((RegularTimePeriod)new Day(1, 3, 2002), 12353.3);
        series1.add((RegularTimePeriod)new Day(2, 3, 2002), 13734.4);
        series1.add((RegularTimePeriod)new Day(3, 3, 2002), 14525.3);
        series1.add((RegularTimePeriod)new Day(4, 3, 2002), 13984.3);
        series1.add((RegularTimePeriod)new Day(5, 3, 2002), 12999.4);
        series1.add((RegularTimePeriod)new Day(6, 3, 2002), 14274.3);
        series1.add((RegularTimePeriod)new Day(7, 3, 2002), 15943.5);
        series1.add((RegularTimePeriod)new Day(8, 3, 2002), 14845.3);
        series1.add((RegularTimePeriod)new Day(9, 3, 2002), 14645.4);
        series1.add((RegularTimePeriod)new Day(10, 3, 2002), 16234.6);
        series1.add((RegularTimePeriod)new Day(11, 3, 2002), 17232.3);
        series1.add((RegularTimePeriod)new Day(12, 3, 2002), 14232.2);
        series1.add((RegularTimePeriod)new Day(13, 3, 2002), 13102.2);
        series1.add((RegularTimePeriod)new Day(14, 3, 2002), 14230.2);
        series1.add((RegularTimePeriod)new Day(15, 3, 2002), 11235.2);
        TimeSeriesCollection collection = new TimeSeriesCollection(series1);
        collection.setDomainIsPointsInTime(false);
        return collection;
    }

    private XYDataset createDataset2() {
        XYSeries series = new XYSeries((Comparable)((Object)"Series 2"));
        XYSeriesCollection collection = new XYSeriesCollection(series);
        return collection;
    }

    public void testSetRenderer() {
        XYPlot plot = new XYPlot();
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        plot.setRenderer(renderer);
        MyPlotChangeListener listener = new MyPlotChangeListener();
        plot.addChangeListener(listener);
        renderer.setSeriesPaint(0, Color.black);
        XYPlotTests.assertTrue((listener.getEvent() != null ? 1 : 0) != 0);
    }
}

