/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.plot.PolarPlot;

public class PolarPlotTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(PolarPlotTests.class);
    }

    public PolarPlotTests(String name) {
        super(name);
    }

    public void testEquals() {
        PolarPlot plot1 = new PolarPlot();
        PolarPlot plot2 = new PolarPlot();
        PolarPlotTests.assertTrue((boolean)plot1.equals(plot2));
        PolarPlotTests.assertTrue((boolean)plot2.equals(plot1));
    }

    public void testCloning() {
        PolarPlot p1 = new PolarPlot();
        PolarPlot p2 = null;
        try {
            p2 = (PolarPlot)p1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            System.err.println("Failed to clone.");
        }
        PolarPlotTests.assertTrue((p1 != p2 ? 1 : 0) != 0);
        PolarPlotTests.assertTrue((p1.getClass() == p2.getClass() ? 1 : 0) != 0);
        PolarPlotTests.assertTrue((boolean)p1.equals(p2));
    }

    public void testSerialization() {
        PolarPlot p1 = new PolarPlot();
        PolarPlot p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (PolarPlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PolarPlotTests.assertEquals((Object)p1, p2);
    }
}

