/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.FastScatterPlot;

public class FastScatterPlotTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(FastScatterPlotTests.class);
    }

    public FastScatterPlotTests(String name) {
        super(name);
    }

    public void testEquals() {
        FastScatterPlot plot1 = new FastScatterPlot();
        FastScatterPlot plot2 = new FastScatterPlot();
        FastScatterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        FastScatterPlotTests.assertTrue((boolean)plot2.equals(plot1));
        plot1.setPaint(Color.yellow);
        FastScatterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setPaint(Color.yellow);
        FastScatterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainGridlinesVisible(false);
        FastScatterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainGridlinesVisible(false);
        FastScatterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainGridlinePaint(Color.red);
        FastScatterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainGridlinePaint(Color.red);
        FastScatterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        BasicStroke s = new BasicStroke(1.5f);
        plot1.setDomainGridlineStroke(s);
        FastScatterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainGridlineStroke(s);
        FastScatterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeGridlinesVisible(false);
        FastScatterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeGridlinesVisible(false);
        FastScatterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeGridlinePaint(Color.red);
        FastScatterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeGridlinePaint(Color.red);
        FastScatterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        BasicStroke s2 = new BasicStroke(1.5f);
        plot1.setRangeGridlineStroke(s2);
        FastScatterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeGridlineStroke(s2);
        FastScatterPlotTests.assertTrue((boolean)plot1.equals(plot2));
    }

    public void testCloning() {
        FastScatterPlot p1 = new FastScatterPlot();
        FastScatterPlot p2 = null;
        try {
            p2 = (FastScatterPlot)p1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            System.err.println("Failed to clone.");
        }
        FastScatterPlotTests.assertTrue((p1 != p2 ? 1 : 0) != 0);
        FastScatterPlotTests.assertTrue((p1.getClass() == p2.getClass() ? 1 : 0) != 0);
        FastScatterPlotTests.assertTrue((boolean)p1.equals(p2));
    }

    public void testSerialization() {
        float[][] data = this.createData();
        NumberAxis domainAxis = new NumberAxis("X");
        NumberAxis rangeAxis = new NumberAxis("Y");
        FastScatterPlot p1 = new FastScatterPlot(data, domainAxis, rangeAxis);
        FastScatterPlot p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (FastScatterPlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        FastScatterPlotTests.assertEquals((Object)p1, p2);
    }

    private float[][] createData() {
        float[][] result = new float[2][1000];
        for (int i = 0; i < result[0].length; ++i) {
            float x;
            result[0][i] = x = (float)i + 100.0f;
            result[1][i] = 100.0f + (float)Math.random() * 1000.0f;
        }
        return result;
    }
}

