/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.plot.CompassPlot;
import org.jfree.data.general.DefaultValueDataset;

public class CompassPlotTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CompassPlotTests.class);
    }

    public CompassPlotTests(String name) {
        super(name);
    }

    public void testEquals() {
        CompassPlot plot1 = new CompassPlot();
        CompassPlot plot2 = new CompassPlot();
        CompassPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelType(1);
        CompassPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelType(1);
        CompassPlotTests.assertTrue((boolean)plot1.equals(plot2));
    }

    public void testSerialization() {
        CompassPlot p1 = new CompassPlot(null);
        CompassPlot p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (CompassPlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        CompassPlotTests.assertEquals((Object)p1, p2);
    }

    public void testCloning() {
        CompassPlot p1 = new CompassPlot(new DefaultValueDataset(15.0));
        CompassPlot p2 = null;
        try {
            p2 = (CompassPlot)p1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            System.err.println("Failed to clone.");
        }
        CompassPlotTests.assertTrue((p1 != p2 ? 1 : 0) != 0);
        CompassPlotTests.assertTrue((p1.getClass() == p2.getClass() ? 1 : 0) != 0);
        CompassPlotTests.assertTrue((boolean)p1.equals(p2));
    }
}

