/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.CategoryTextAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.junit.MyPlotChangeListener;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.SortOrder;

public class CategoryPlotTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CategoryPlotTests.class);
    }

    public CategoryPlotTests(String name) {
        super(name);
    }

    public void testAxisRange() {
        DefaultCategoryDataset datasetA = new DefaultCategoryDataset();
        DefaultCategoryDataset datasetB = new DefaultCategoryDataset();
        datasetB.addValue(50.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        datasetB.addValue(80.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        CategoryPlot plot = new CategoryPlot(datasetA, new CategoryAxis(null), new NumberAxis(null), new LineAndShapeRenderer());
        plot.setDataset(1, datasetB);
        plot.setRenderer(1, new LineAndShapeRenderer());
        Range r = plot.getRangeAxis().getRange();
        CategoryPlotTests.assertEquals((double)84.0, (double)r.getUpperBound(), (double)1.0E-5);
    }

    public void testEquals() {
        CategoryPlot plot1 = new CategoryPlot();
        CategoryPlot plot2 = new CategoryPlot();
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        CategoryPlotTests.assertTrue((boolean)plot2.equals(plot1));
        plot1.setOrientation(PlotOrientation.HORIZONTAL);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setOrientation(PlotOrientation.HORIZONTAL);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setAxisOffset(new RectangleInsets(0.05, 0.05, 0.05, 0.05));
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setAxisOffset(new RectangleInsets(0.05, 0.05, 0.05, 0.05));
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainAxis(new CategoryAxis("Category Axis"));
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainAxis(new CategoryAxis("Category Axis"));
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainAxis(11, new CategoryAxis("Secondary Axis"));
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainAxis(11, new CategoryAxis("Secondary Axis"));
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainAxisLocation(AxisLocation.TOP_OR_RIGHT);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainAxisLocation(AxisLocation.TOP_OR_RIGHT);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDrawSharedDomainAxis(!plot1.getDrawSharedDomainAxis());
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDrawSharedDomainAxis(!plot2.getDrawSharedDomainAxis());
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeAxis(new NumberAxis("Range Axis"));
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeAxis(new NumberAxis("Range Axis"));
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeAxis(11, new NumberAxis("Secondary Range Axis"));
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeAxis(11, new NumberAxis("Secondary Range Axis"));
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeAxisLocation(AxisLocation.TOP_OR_RIGHT);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeAxisLocation(AxisLocation.TOP_OR_RIGHT);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.mapDatasetToDomainAxis(11, 11);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.mapDatasetToDomainAxis(11, 11);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.mapDatasetToRangeAxis(11, 11);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.mapDatasetToRangeAxis(11, 11);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRenderer(new AreaRenderer());
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRenderer(new AreaRenderer());
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRenderer(11, new AreaRenderer());
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRenderer(11, new AreaRenderer());
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setColumnRenderingOrder(SortOrder.DESCENDING);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setColumnRenderingOrder(SortOrder.DESCENDING);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRowRenderingOrder(SortOrder.DESCENDING);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRowRenderingOrder(SortOrder.DESCENDING);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainGridlinesVisible(true);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainGridlinesVisible(true);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainGridlinePosition(CategoryAnchor.END);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainGridlinePosition(CategoryAnchor.END);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        BasicStroke stroke = new BasicStroke(2.0f);
        plot1.setDomainGridlineStroke(stroke);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainGridlineStroke(stroke);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainGridlinePaint(Color.blue);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainGridlinePaint(Color.blue);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeGridlinesVisible(false);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeGridlinesVisible(false);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeGridlineStroke(stroke);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeGridlineStroke(stroke);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeGridlinePaint(Color.blue);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeGridlinePaint(Color.blue);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setAnchorValue(100.0);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setAnchorValue(100.0);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeCrosshairVisible(true);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeCrosshairVisible(true);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeCrosshairValue(100.0);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeCrosshairValue(100.0);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeCrosshairStroke(stroke);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeCrosshairStroke(stroke);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeCrosshairPaint(Color.blue);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeCrosshairPaint(Color.blue);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeCrosshairLockedOnData(false);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeCrosshairLockedOnData(false);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.addRangeMarker(new ValueMarker(4.0), Layer.FOREGROUND);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.addRangeMarker(new ValueMarker(4.0), Layer.FOREGROUND);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.addRangeMarker(new ValueMarker(5.0), Layer.BACKGROUND);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.addRangeMarker(new ValueMarker(5.0), Layer.BACKGROUND);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.addRangeMarker(1, new ValueMarker(4.0), Layer.FOREGROUND);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.addRangeMarker(1, new ValueMarker(4.0), Layer.FOREGROUND);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.addRangeMarker(1, new ValueMarker(5.0), Layer.BACKGROUND);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.addRangeMarker(1, new ValueMarker(5.0), Layer.BACKGROUND);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.addAnnotation(new CategoryTextAnnotation("Text", (Comparable)((Object)"Category"), 43.0));
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.addAnnotation(new CategoryTextAnnotation("Text", (Comparable)((Object)"Category"), 43.0));
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setWeight(3);
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setWeight(3);
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setFixedDomainAxisSpace(new AxisSpace());
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setFixedDomainAxisSpace(new AxisSpace());
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setFixedRangeAxisSpace(new AxisSpace());
        CategoryPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setFixedRangeAxisSpace(new AxisSpace());
        CategoryPlotTests.assertTrue((boolean)plot1.equals(plot2));
    }

    public void testCloning() {
        CategoryPlot p1 = new CategoryPlot();
        CategoryPlot p2 = null;
        try {
            p2 = (CategoryPlot)p1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            System.err.println("Failed to clone.");
        }
        CategoryPlotTests.assertTrue((p1 != p2 ? 1 : 0) != 0);
        CategoryPlotTests.assertTrue((p1.getClass() == p2.getClass() ? 1 : 0) != 0);
        CategoryPlotTests.assertTrue((boolean)p1.equals(p2));
    }

    public void testSerialization() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        CategoryAxis domainAxis = new CategoryAxis("Domain");
        NumberAxis rangeAxis = new NumberAxis("Range");
        BarRenderer renderer = new BarRenderer();
        CategoryPlot p1 = new CategoryPlot(dataset, domainAxis, rangeAxis, renderer);
        p1.setOrientation(PlotOrientation.HORIZONTAL);
        CategoryPlot p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (CategoryPlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CategoryPlotTests.assertTrue((boolean)p1.equals(p2));
    }

    public void testSerialization2() {
        DefaultCategoryDataset data = new DefaultCategoryDataset();
        CategoryAxis domainAxis = new CategoryAxis("Domain");
        NumberAxis rangeAxis = new NumberAxis("Range");
        BarRenderer renderer = new BarRenderer();
        CategoryPlot p1 = new CategoryPlot(data, domainAxis, rangeAxis, renderer);
        p1.setOrientation(PlotOrientation.VERTICAL);
        CategoryPlot p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (CategoryPlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            CategoryPlotTests.fail((String)e.toString());
        }
        CategoryPlotTests.assertEquals((Object)p1, p2);
    }

    public void testSerialization3() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        JFreeChart chart = ChartFactory.createBarChart("Test Chart", "Category Axis", "Value Axis", dataset, PlotOrientation.VERTICAL, true, true, false);
        JFreeChart chart2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(chart);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            chart2 = (JFreeChart)in.readObject();
            in.close();
        }
        catch (Exception e) {
            CategoryPlotTests.fail((String)e.toString());
        }
        boolean passed = true;
        try {
            chart2.createBufferedImage(300, 200);
        }
        catch (Exception e) {
            passed = false;
            e.printStackTrace();
        }
        CategoryPlotTests.assertTrue((boolean)passed);
    }

    public void testSerialization4() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        JFreeChart chart = ChartFactory.createBarChart("Test Chart", "Category Axis", "Value Axis", dataset, PlotOrientation.VERTICAL, true, true, false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.addRangeMarker(new ValueMarker(1.1), Layer.FOREGROUND);
        plot.addRangeMarker(new IntervalMarker(2.2, 3.3), Layer.BACKGROUND);
        JFreeChart chart2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(chart);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            chart2 = (JFreeChart)in.readObject();
            in.close();
        }
        catch (Exception e) {
            CategoryPlotTests.fail((String)e.toString());
        }
        CategoryPlotTests.assertEquals((Object)chart, chart2);
        boolean passed = true;
        try {
            chart2.createBufferedImage(300, 200);
        }
        catch (Exception e) {
            passed = false;
            e.printStackTrace();
        }
        CategoryPlotTests.assertTrue((boolean)passed);
    }

    public void testSerialization5() {
        DefaultCategoryDataset dataset1 = new DefaultCategoryDataset();
        CategoryAxis domainAxis1 = new CategoryAxis("Domain 1");
        NumberAxis rangeAxis1 = new NumberAxis("Range 1");
        BarRenderer renderer1 = new BarRenderer();
        CategoryPlot p1 = new CategoryPlot(dataset1, domainAxis1, rangeAxis1, renderer1);
        CategoryAxis domainAxis2 = new CategoryAxis("Domain 2");
        NumberAxis rangeAxis2 = new NumberAxis("Range 2");
        BarRenderer renderer2 = new BarRenderer();
        DefaultCategoryDataset dataset2 = new DefaultCategoryDataset();
        p1.setDataset(1, dataset2);
        p1.setDomainAxis(1, domainAxis2);
        p1.setRangeAxis(1, rangeAxis2);
        p1.setRenderer(1, renderer2);
        CategoryPlot p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (CategoryPlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            CategoryPlotTests.fail((String)e.toString());
        }
        CategoryPlotTests.assertEquals((Object)p1, p2);
        CategoryAxis domainAxisA = p2.getDomainAxis(0);
        NumberAxis rangeAxisA = (NumberAxis)p2.getRangeAxis(0);
        DefaultCategoryDataset datasetA = (DefaultCategoryDataset)p2.getDataset(0);
        BarRenderer rendererA = (BarRenderer)p2.getRenderer(0);
        CategoryAxis domainAxisB = p2.getDomainAxis(1);
        NumberAxis rangeAxisB = (NumberAxis)p2.getRangeAxis(1);
        DefaultCategoryDataset datasetB = (DefaultCategoryDataset)p2.getDataset(1);
        BarRenderer rendererB = (BarRenderer)p2.getRenderer(1);
        CategoryPlotTests.assertTrue((boolean)datasetA.hasListener(p2));
        CategoryPlotTests.assertTrue((boolean)domainAxisA.hasListener(p2));
        CategoryPlotTests.assertTrue((boolean)rangeAxisA.hasListener(p2));
        CategoryPlotTests.assertTrue((boolean)rendererA.hasListener(p2));
        CategoryPlotTests.assertTrue((boolean)datasetB.hasListener(p2));
        CategoryPlotTests.assertTrue((boolean)domainAxisB.hasListener(p2));
        CategoryPlotTests.assertTrue((boolean)rangeAxisB.hasListener(p2));
        CategoryPlotTests.assertTrue((boolean)rendererB.hasListener(p2));
    }

    public void testSetRenderer() {
        CategoryPlot plot = new CategoryPlot();
        LineAndShapeRenderer renderer = new LineAndShapeRenderer();
        plot.setRenderer(renderer);
        MyPlotChangeListener listener = new MyPlotChangeListener();
        plot.addChangeListener(listener);
        renderer.setSeriesPaint(0, Color.black);
        CategoryPlotTests.assertTrue((listener.getEvent() != null ? 1 : 0) != 0);
    }

    public void test1169972() {
        CategoryPlot plot = new CategoryPlot(null, null, null, null);
        plot.setDomainAxis(new CategoryAxis("C"));
        plot.setRangeAxis(new NumberAxis("Y"));
        plot.setRenderer(new BarRenderer());
        plot.setDataset(new DefaultCategoryDataset());
        CategoryPlotTests.assertTrue((plot != null ? 1 : 0) != 0);
    }
}

