/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.SymbolicXYItemLabelGenerator;

public class SymbolicXYItemLabelGeneratorTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(SymbolicXYItemLabelGeneratorTests.class);
    }

    public SymbolicXYItemLabelGeneratorTests(String name) {
        super(name);
    }

    public void testEquals() {
        SymbolicXYItemLabelGenerator g1 = new SymbolicXYItemLabelGenerator();
        SymbolicXYItemLabelGenerator g2 = new SymbolicXYItemLabelGenerator();
        SymbolicXYItemLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        SymbolicXYItemLabelGeneratorTests.assertTrue((boolean)g2.equals(g1));
    }

    public void testCloning() {
        SymbolicXYItemLabelGenerator g1 = new SymbolicXYItemLabelGenerator();
        SymbolicXYItemLabelGenerator g2 = null;
        try {
            g2 = (SymbolicXYItemLabelGenerator)g1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        SymbolicXYItemLabelGeneratorTests.assertTrue((g1 != g2 ? 1 : 0) != 0);
        SymbolicXYItemLabelGeneratorTests.assertTrue((g1.getClass() == g2.getClass() ? 1 : 0) != 0);
        SymbolicXYItemLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
    }

    public void testSerialization() {
        SymbolicXYItemLabelGenerator g1 = new SymbolicXYItemLabelGenerator();
        SymbolicXYItemLabelGenerator g2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(g1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            g2 = (SymbolicXYItemLabelGenerator)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        SymbolicXYItemLabelGeneratorTests.assertEquals((Object)g1, g2);
    }
}

