/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;

public class StandardPieSectionLabelGeneratorTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StandardPieSectionLabelGeneratorTests.class);
    }

    public StandardPieSectionLabelGeneratorTests(String name) {
        super(name);
    }

    public void testEquals() {
        StandardPieSectionLabelGenerator g1 = new StandardPieSectionLabelGenerator();
        StandardPieSectionLabelGenerator g2 = new StandardPieSectionLabelGenerator();
        StandardPieSectionLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        StandardPieSectionLabelGeneratorTests.assertTrue((boolean)g2.equals(g1));
        g1 = new StandardPieSectionLabelGenerator("{0}", new DecimalFormat("#,##0.00"), NumberFormat.getPercentInstance());
        StandardPieSectionLabelGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardPieSectionLabelGenerator("{0}", new DecimalFormat("#,##0.00"), NumberFormat.getPercentInstance());
        StandardPieSectionLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardPieSectionLabelGenerator("{0} {1}", new DecimalFormat("#,##0.00"), NumberFormat.getPercentInstance());
        StandardPieSectionLabelGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardPieSectionLabelGenerator("{0} {1}", new DecimalFormat("#,##0.00"), NumberFormat.getPercentInstance());
        StandardPieSectionLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardPieSectionLabelGenerator("{0} {1}", new DecimalFormat("#,##0"), NumberFormat.getPercentInstance());
        StandardPieSectionLabelGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardPieSectionLabelGenerator("{0} {1}", new DecimalFormat("#,##0"), NumberFormat.getPercentInstance());
        StandardPieSectionLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardPieSectionLabelGenerator("{0} {1}", new DecimalFormat("#,##0"), new DecimalFormat("0.000%"));
        StandardPieSectionLabelGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardPieSectionLabelGenerator("{0} {1}", new DecimalFormat("#,##0"), new DecimalFormat("0.000%"));
        StandardPieSectionLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
    }

    public void testCloning() {
        StandardPieSectionLabelGenerator g1 = new StandardPieSectionLabelGenerator();
        StandardPieSectionLabelGenerator g2 = null;
        try {
            g2 = (StandardPieSectionLabelGenerator)g1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        StandardPieSectionLabelGeneratorTests.assertTrue((g1 != g2 ? 1 : 0) != 0);
        StandardPieSectionLabelGeneratorTests.assertTrue((g1.getClass() == g2.getClass() ? 1 : 0) != 0);
        StandardPieSectionLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
    }

    public void testSerialization() {
        StandardPieSectionLabelGenerator g1 = new StandardPieSectionLabelGenerator();
        StandardPieSectionLabelGenerator g2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(g1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            g2 = (StandardPieSectionLabelGenerator)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StandardPieSectionLabelGeneratorTests.assertEquals((Object)g1, g2);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)StandardPieSectionLabelGeneratorTests.suite());
    }
}

