/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.IntervalCategoryItemLabelGenerator;

public class IntervalCategoryLabelGeneratorTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(IntervalCategoryLabelGeneratorTests.class);
    }

    public IntervalCategoryLabelGeneratorTests(String name) {
        super(name);
    }

    public void testEquals() {
        IntervalCategoryItemLabelGenerator g1 = new IntervalCategoryItemLabelGenerator();
        IntervalCategoryItemLabelGenerator g2 = new IntervalCategoryItemLabelGenerator();
        IntervalCategoryLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        IntervalCategoryLabelGeneratorTests.assertTrue((boolean)g2.equals(g1));
        g1 = new IntervalCategoryItemLabelGenerator("{3} - {4}", new DecimalFormat("0.000"));
        IntervalCategoryLabelGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new IntervalCategoryItemLabelGenerator("{3} - {4}", new DecimalFormat("0.000"));
        IntervalCategoryLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new IntervalCategoryItemLabelGenerator("{3} - {4}", new SimpleDateFormat("d-MMM"));
        IntervalCategoryLabelGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new IntervalCategoryItemLabelGenerator("{3} - {4}", new SimpleDateFormat("d-MMM"));
        IntervalCategoryLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
    }

    public void testCloning() {
        IntervalCategoryItemLabelGenerator g1 = new IntervalCategoryItemLabelGenerator();
        IntervalCategoryItemLabelGenerator g2 = null;
        try {
            g2 = (IntervalCategoryItemLabelGenerator)g1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        IntervalCategoryLabelGeneratorTests.assertTrue((g1 != g2 ? 1 : 0) != 0);
        IntervalCategoryLabelGeneratorTests.assertTrue((g1.getClass() == g2.getClass() ? 1 : 0) != 0);
        IntervalCategoryLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
    }

    public void testSerialization() {
        IntervalCategoryItemLabelGenerator g1 = new IntervalCategoryItemLabelGenerator("{3} - {4}", DateFormat.getInstance());
        IntervalCategoryItemLabelGenerator g2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(g1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            g2 = (IntervalCategoryItemLabelGenerator)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        IntervalCategoryLabelGeneratorTests.assertEquals((Object)g1, g2);
    }
}

