/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.junit;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class PieChart3DTests
extends TestCase {
    private JFreeChart pieChart;

    public static Test suite() {
        return new TestSuite(PieChart3DTests.class);
    }

    public PieChart3DTests(String name) {
        super(name);
    }

    protected void setUp() {
        DefaultPieDataset dataset = new DefaultPieDataset();
        dataset.setValue((Comparable)((Object)"Java"), new Double(43.2));
        dataset.setValue((Comparable)((Object)"Visual Basic"), new Double(0.0));
        dataset.setValue((Comparable)((Object)"C/C++"), new Double(17.5));
        this.pieChart = PieChart3DTests.createPieChart3D(dataset);
    }

    public void testReplaceDatasetOnPieChart() {
        LocalListener l = new LocalListener();
        this.pieChart.addChangeListener(l);
        PiePlot plot = (PiePlot)this.pieChart.getPlot();
        plot.setDataset(null);
        PieChart3DTests.assertEquals((boolean)true, (boolean)l.flag);
        PieChart3DTests.assertNull((Object)plot.getDataset());
    }

    public void testNullValueInDataset() {
        DefaultPieDataset dataset = new DefaultPieDataset();
        dataset.setValue((Comparable)((Object)"Section 1"), 10.0);
        dataset.setValue((Comparable)((Object)"Section 2"), 11.0);
        dataset.setValue((Comparable)((Object)"Section 3"), null);
        JFreeChart chart = PieChart3DTests.createPieChart3D(dataset);
        boolean success = false;
        try {
            BufferedImage image = new BufferedImage(200, 100, 1);
            Graphics2D g2 = image.createGraphics();
            chart.draw(g2, new Rectangle2D.Double(0.0, 0.0, 200.0, 100.0), null, null);
            g2.dispose();
            success = true;
        }
        catch (Throwable t) {
            success = false;
        }
        PieChart3DTests.assertTrue((boolean)success);
    }

    private static JFreeChart createPieChart3D(PieDataset dataset) {
        return ChartFactory.createPieChart3D("Pie Chart", dataset, true, true, false);
    }

    static class LocalListener
    implements ChartChangeListener {
        private boolean flag = false;

        LocalListener() {
        }

        public void chartChanged(ChartChangeEvent event) {
            this.flag = true;
        }
    }
}

