/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity.junit;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.data.time.TimeSeriesCollection;

public class XYItemEntityTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYItemEntityTests.class);
    }

    public XYItemEntityTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYItemEntity e1 = new XYItemEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new TimeSeriesCollection(), 1, 9, "ToolTip", "URL");
        XYItemEntity e2 = new XYItemEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new TimeSeriesCollection(), 1, 9, "ToolTip", "URL");
        XYItemEntityTests.assertTrue((boolean)e1.equals(e2));
        e1.setArea(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0));
        XYItemEntityTests.assertFalse((boolean)e1.equals(e2));
        e2.setArea(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0));
        XYItemEntityTests.assertTrue((boolean)e1.equals(e2));
        e1.setToolTipText("New ToolTip");
        XYItemEntityTests.assertFalse((boolean)e1.equals(e2));
        e2.setToolTipText("New ToolTip");
        XYItemEntityTests.assertTrue((boolean)e1.equals(e2));
        e1.setURLText("New URL");
        XYItemEntityTests.assertFalse((boolean)e1.equals(e2));
        e2.setURLText("New URL");
        XYItemEntityTests.assertTrue((boolean)e1.equals(e2));
        e1.setSeriesIndex(88);
        XYItemEntityTests.assertFalse((boolean)e1.equals(e2));
        e2.setSeriesIndex(88);
        XYItemEntityTests.assertTrue((boolean)e1.equals(e2));
        e1.setItem(88);
        XYItemEntityTests.assertFalse((boolean)e1.equals(e2));
        e2.setItem(88);
        XYItemEntityTests.assertTrue((boolean)e1.equals(e2));
    }

    public void testCloning() {
        XYItemEntity e1 = new XYItemEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new TimeSeriesCollection(), 1, 9, "ToolTip", "URL");
        XYItemEntity e2 = null;
        try {
            e2 = (XYItemEntity)e1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        XYItemEntityTests.assertTrue((e1 != e2 ? 1 : 0) != 0);
        XYItemEntityTests.assertTrue((e1.getClass() == e2.getClass() ? 1 : 0) != 0);
        XYItemEntityTests.assertTrue((boolean)e1.equals(e2));
    }

    public void testSerialization() {
        XYItemEntity e1 = new XYItemEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new TimeSeriesCollection(), 1, 9, "ToolTip", "URL");
        XYItemEntity e2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(e1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            e2 = (XYItemEntity)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        XYItemEntityTests.assertEquals((Object)e1, e2);
    }
}

