/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity.junit;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.data.general.DefaultPieDataset;

public class StandardEntityCollectionTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StandardEntityCollectionTests.class);
    }

    public StandardEntityCollectionTests(String name) {
        super(name);
    }

    public void testEquals() {
        PieSectionEntity e1 = new PieSectionEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new DefaultPieDataset(), 0, 1, (Comparable)((Object)"Key"), "ToolTip", "URL");
        StandardEntityCollection c1 = new StandardEntityCollection();
        c1.add(e1);
        PieSectionEntity e2 = new PieSectionEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new DefaultPieDataset(), 0, 1, (Comparable)((Object)"Key"), "ToolTip", "URL");
        StandardEntityCollection c2 = new StandardEntityCollection();
        c2.add(e2);
        StandardEntityCollectionTests.assertTrue((boolean)c1.equals(c2));
    }

    public void testCloning() {
        PieSectionEntity e1 = new PieSectionEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new DefaultPieDataset(), 0, 1, (Comparable)((Object)"Key"), "ToolTip", "URL");
        StandardEntityCollection c1 = new StandardEntityCollection();
        c1.add(e1);
        StandardEntityCollection c2 = null;
        try {
            c2 = (StandardEntityCollection)c1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        StandardEntityCollectionTests.assertTrue((c1 != c2 ? 1 : 0) != 0);
        StandardEntityCollectionTests.assertTrue((c1.getClass() == c2.getClass() ? 1 : 0) != 0);
        StandardEntityCollectionTests.assertTrue((boolean)c1.equals(c2));
    }

    public void testSerialization() {
        PieSectionEntity e1 = new PieSectionEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new DefaultPieDataset(), 0, 1, (Comparable)((Object)"Key"), "ToolTip", "URL");
        StandardEntityCollection c1 = new StandardEntityCollection();
        c1.add(e1);
        StandardEntityCollection c2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(c1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            c2 = (StandardEntityCollection)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        StandardEntityCollectionTests.assertEquals((Object)c1, c2);
    }
}

