/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.block.FlowArrangement;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.VerticalAlignment;

public class FlowArrangementTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(FlowArrangementTests.class);
    }

    public FlowArrangementTests(String name) {
        super(name);
    }

    public void testEquals() {
        FlowArrangement f1 = new FlowArrangement(HorizontalAlignment.LEFT, VerticalAlignment.TOP, 1.0, 2.0);
        FlowArrangement f2 = new FlowArrangement(HorizontalAlignment.LEFT, VerticalAlignment.TOP, 1.0, 2.0);
        FlowArrangementTests.assertTrue((boolean)f1.equals(f2));
        FlowArrangementTests.assertTrue((boolean)f2.equals(f1));
        f1 = new FlowArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 1.0, 2.0);
        FlowArrangementTests.assertFalse((boolean)f1.equals(f2));
        f2 = new FlowArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 1.0, 2.0);
        FlowArrangementTests.assertTrue((boolean)f1.equals(f2));
        f1 = new FlowArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.0, 2.0);
        FlowArrangementTests.assertFalse((boolean)f1.equals(f2));
        f2 = new FlowArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.0, 2.0);
        FlowArrangementTests.assertTrue((boolean)f1.equals(f2));
        f1 = new FlowArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.1, 2.0);
        FlowArrangementTests.assertFalse((boolean)f1.equals(f2));
        f2 = new FlowArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.1, 2.0);
        FlowArrangementTests.assertTrue((boolean)f1.equals(f2));
        f1 = new FlowArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.1, 2.2);
        FlowArrangementTests.assertFalse((boolean)f1.equals(f2));
        f2 = new FlowArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.1, 2.2);
        FlowArrangementTests.assertTrue((boolean)f1.equals(f2));
    }

    public void testCloning() {
        FlowArrangement f1 = new FlowArrangement();
        FlowArrangementTests.assertFalse((boolean)(f1 instanceof Cloneable));
    }

    public void testSerialization() {
        FlowArrangement f1 = new FlowArrangement(HorizontalAlignment.LEFT, VerticalAlignment.TOP, 1.0, 2.0);
        FlowArrangement f2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(f1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            f2 = (FlowArrangement)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        FlowArrangementTests.assertEquals((Object)f1, f2);
    }
}

