/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block.junit;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.BorderArrangement;
import org.jfree.chart.block.EmptyBlock;
import org.jfree.chart.block.LengthConstraintType;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.Size2D;

public class BorderArrangementTests
extends TestCase {
    private static final double EPSILON = 1.0E-10;

    public static Test suite() {
        return new TestSuite(BorderArrangementTests.class);
    }

    public BorderArrangementTests(String name) {
        super(name);
    }

    public void testEquals() {
        BorderArrangement b1 = new BorderArrangement();
        BorderArrangement b2 = new BorderArrangement();
        BorderArrangementTests.assertTrue((boolean)b1.equals(b2));
        BorderArrangementTests.assertTrue((boolean)b2.equals(b1));
        b1.add(new EmptyBlock(99.0, 99.0), null);
        BorderArrangementTests.assertFalse((boolean)b1.equals(b2));
        b2.add(new EmptyBlock(99.0, 99.0), null);
        BorderArrangementTests.assertTrue((boolean)b1.equals(b2));
        b1.add(new EmptyBlock(1.0, 1.0), RectangleEdge.LEFT);
        BorderArrangementTests.assertFalse((boolean)b1.equals(b2));
        b2.add(new EmptyBlock(1.0, 1.0), RectangleEdge.LEFT);
        BorderArrangementTests.assertTrue((boolean)b1.equals(b2));
        b1.add(new EmptyBlock(2.0, 2.0), RectangleEdge.RIGHT);
        BorderArrangementTests.assertFalse((boolean)b1.equals(b2));
        b2.add(new EmptyBlock(2.0, 2.0), RectangleEdge.RIGHT);
        BorderArrangementTests.assertTrue((boolean)b1.equals(b2));
        b1.add(new EmptyBlock(3.0, 3.0), RectangleEdge.TOP);
        BorderArrangementTests.assertFalse((boolean)b1.equals(b2));
        b2.add(new EmptyBlock(3.0, 3.0), RectangleEdge.TOP);
        BorderArrangementTests.assertTrue((boolean)b1.equals(b2));
        b1.add(new EmptyBlock(4.0, 4.0), RectangleEdge.BOTTOM);
        BorderArrangementTests.assertFalse((boolean)b1.equals(b2));
        b2.add(new EmptyBlock(4.0, 4.0), RectangleEdge.BOTTOM);
        BorderArrangementTests.assertTrue((boolean)b1.equals(b2));
    }

    public void testCloning() {
        BorderArrangement b1 = new BorderArrangement();
        BorderArrangementTests.assertFalse((boolean)(b1 instanceof Cloneable));
    }

    public void testSerialization() {
        BorderArrangement b1 = new BorderArrangement();
        BorderArrangement b2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(b1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            b2 = (BorderArrangement)in.readObject();
            in.close();
        }
        catch (Exception e) {
            BorderArrangementTests.fail((String)e.toString());
        }
        BorderArrangementTests.assertEquals((Object)b1, b2);
    }

    public void testSizing() {
        BlockContainer container = new BlockContainer(new BorderArrangement());
        BufferedImage image = new BufferedImage(200, 100, 1);
        Graphics2D g2 = image.createGraphics();
        Size2D size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)0.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)0.0, (double)size.height, (double)1.0E-10);
        container.add(new EmptyBlock(123.4, 567.8));
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)123.4, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)567.8, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.RIGHT);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)12.3, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0));
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.RIGHT);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)22.3, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size.height, (double)1.0E-10);
        container.clear();
        EmptyBlock rb = new EmptyBlock(12.3, 15.6);
        container.add(new EmptyBlock(10.0, 20.0));
        container.add(rb, RectangleEdge.RIGHT);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)22.3, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)20.0, (double)size.height, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)20.0, (double)rb.getBounds().getHeight(), (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)12.3, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0));
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)22.3, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size.height, (double)1.0E-10);
        container.clear();
        EmptyBlock lb = new EmptyBlock(12.3, 15.6);
        container.add(new EmptyBlock(10.0, 20.0));
        container.add(lb, RectangleEdge.LEFT);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)22.3, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)20.0, (double)size.height, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)20.0, (double)lb.getBounds().getHeight(), (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)22.3, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0));
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        container.add(new EmptyBlock(5.4, 3.2), RectangleEdge.RIGHT);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)27.7, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)12.3, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0));
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)12.3, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)12.3, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(21.0, 12.3));
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)31.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.LEFT);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)12.3, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(21.0, 12.3));
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.LEFT);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)31.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(21.0, 12.3), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.LEFT);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)31.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(3.0, 4.0), RectangleEdge.BOTTOM);
        container.add(new EmptyBlock(5.0, 6.0), RectangleEdge.LEFT);
        container.add(new EmptyBlock(7.0, 8.0), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(9.0, 10.0));
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)21.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)14.0, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.TOP);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)12.3, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0));
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.TOP);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)12.3, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.TOP);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)12.3, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(21.0, 12.3));
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.RIGHT);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)33.3, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.LEFT);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.TOP);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)12.3, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(21.0, 12.3));
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)33.3, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(21.0, 12.3), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)33.3, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(1.0, 2.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(5.0, 6.0), RectangleEdge.LEFT);
        container.add(new EmptyBlock(7.0, 8.0), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(9.0, 10.0));
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)21.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)12.0, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)12.3, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(21.0, 12.3));
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)21.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)77.9, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(21.0, 12.3), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)21.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)77.9, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(1.0, 2.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(3.0, 4.0), RectangleEdge.BOTTOM);
        container.add(new EmptyBlock(7.0, 8.0), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(9.0, 10.0));
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)16.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)16.0, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(21.0, 12.3), RectangleEdge.LEFT);
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)21.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)77.9, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(1.0, 2.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(3.0, 4.0), RectangleEdge.BOTTOM);
        container.add(new EmptyBlock(5.0, 6.0), RectangleEdge.LEFT);
        container.add(new EmptyBlock(9.0, 10.0));
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)14.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)16.0, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(1.0, 2.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(3.0, 4.0), RectangleEdge.BOTTOM);
        container.add(new EmptyBlock(5.0, 6.0), RectangleEdge.LEFT);
        container.add(new EmptyBlock(7.0, 8.0), RectangleEdge.RIGHT);
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)12.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)14.0, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(1.0, 2.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(3.0, 4.0), RectangleEdge.BOTTOM);
        container.add(new EmptyBlock(5.0, 6.0), RectangleEdge.LEFT);
        container.add(new EmptyBlock(7.0, 8.0), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(9.0, 10.0));
        size = container.arrange(g2);
        BorderArrangementTests.assertEquals((double)21.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)16.0, (double)size.height, (double)1.0E-10);
    }

    public void testSizingWithWidthConstraint() {
        RectangleConstraint constraint = new RectangleConstraint(10.0, new Range(10.0, 10.0), LengthConstraintType.FIXED, 0.0, new Range(0.0, 0.0), LengthConstraintType.NONE);
        BlockContainer container = new BlockContainer(new BorderArrangement());
        BufferedImage image = new BufferedImage(200, 100, 1);
        Graphics2D g2 = image.createGraphics();
        container.add(new EmptyBlock(5.0, 6.0));
        Size2D size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)6.0, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(15.0, 16.0));
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)16.0, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.RIGHT);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(7.0, 20.0));
        container.add(new EmptyBlock(8.0, 45.6), RectangleEdge.RIGHT);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0));
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0));
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        container.add(new EmptyBlock(5.4, 3.2), RectangleEdge.RIGHT);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0));
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(21.0, 12.3));
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.LEFT);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(21.0, 12.3));
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.LEFT);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(21.0, 12.3), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.LEFT);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(3.0, 4.0), RectangleEdge.BOTTOM);
        container.add(new EmptyBlock(5.0, 6.0), RectangleEdge.LEFT);
        container.add(new EmptyBlock(7.0, 8.0), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(9.0, 10.0));
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)14.0, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.TOP);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)45.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0));
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.TOP);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.TOP);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(21.0, 12.3));
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.RIGHT);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.LEFT);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.TOP);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(21.0, 12.3));
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(21.0, 12.3), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.LEFT);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(1.0, 2.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(5.0, 6.0), RectangleEdge.LEFT);
        container.add(new EmptyBlock(7.0, 8.0), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(9.0, 10.0));
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)12.0, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)65.6, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(21.0, 12.3));
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)77.9, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(21.0, 12.3), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)77.9, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(1.0, 2.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(3.0, 4.0), RectangleEdge.BOTTOM);
        container.add(new EmptyBlock(7.0, 8.0), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(9.0, 10.0));
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)16.0, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(21.0, 12.3), RectangleEdge.LEFT);
        container.add(new EmptyBlock(10.0, 20.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(12.3, 45.6), RectangleEdge.BOTTOM);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)77.9, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(1.0, 2.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(3.0, 4.0), RectangleEdge.BOTTOM);
        container.add(new EmptyBlock(5.0, 6.0), RectangleEdge.LEFT);
        container.add(new EmptyBlock(9.0, 10.0));
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)16.0, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(1.0, 2.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(3.0, 4.0), RectangleEdge.BOTTOM);
        container.add(new EmptyBlock(5.0, 6.0), RectangleEdge.LEFT);
        container.add(new EmptyBlock(7.0, 8.0), RectangleEdge.RIGHT);
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)14.0, (double)size.height, (double)1.0E-10);
        container.clear();
        container.add(new EmptyBlock(1.0, 2.0), RectangleEdge.TOP);
        container.add(new EmptyBlock(3.0, 4.0), RectangleEdge.BOTTOM);
        container.add(new EmptyBlock(5.0, 6.0), RectangleEdge.LEFT);
        container.add(new EmptyBlock(7.0, 8.0), RectangleEdge.RIGHT);
        container.add(new EmptyBlock(9.0, 10.0));
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)16.0, (double)size.height, (double)1.0E-10);
        container.clear();
        size = container.arrange(g2, constraint);
        BorderArrangementTests.assertEquals((double)10.0, (double)size.width, (double)1.0E-10);
        BorderArrangementTests.assertEquals((double)0.0, (double)size.height, (double)1.0E-10);
    }
}

