/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block.junit;

import java.awt.Color;
import java.awt.GradientPaint;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.block.BlockBorder;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.UnitType;

public class BlockBorderTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(BlockBorderTests.class);
    }

    public BlockBorderTests(String name) {
        super(name);
    }

    public void testEquals() {
        BlockBorder b1 = new BlockBorder(new RectangleInsets(1.0, 2.0, 3.0, 4.0), Color.red);
        BlockBorder b2 = new BlockBorder(new RectangleInsets(1.0, 2.0, 3.0, 4.0), Color.red);
        BlockBorderTests.assertTrue((boolean)b1.equals(b2));
        BlockBorderTests.assertTrue((boolean)b2.equals(b2));
        b1 = new BlockBorder(new RectangleInsets(UnitType.RELATIVE, 1.0, 2.0, 3.0, 4.0), Color.red);
        BlockBorderTests.assertFalse((boolean)b1.equals(b2));
        b2 = new BlockBorder(new RectangleInsets(UnitType.RELATIVE, 1.0, 2.0, 3.0, 4.0), Color.red);
        BlockBorderTests.assertTrue((boolean)b1.equals(b2));
        b1 = new BlockBorder(new RectangleInsets(1.0, 2.0, 3.0, 4.0), Color.blue);
        BlockBorderTests.assertFalse((boolean)b1.equals(b2));
        b2 = new BlockBorder(new RectangleInsets(1.0, 2.0, 3.0, 4.0), Color.blue);
        BlockBorderTests.assertTrue((boolean)b1.equals(b2));
    }

    public void testCloning() {
        BlockBorder b1 = new BlockBorder();
        BlockBorderTests.assertFalse((boolean)(b1 instanceof Cloneable));
    }

    public void testSerialization() {
        BlockBorder b1 = new BlockBorder(new RectangleInsets(1.0, 2.0, 3.0, 4.0), new GradientPaint(1.0f, 2.0f, Color.red, 3.0f, 4.0f, Color.yellow));
        BlockBorder b2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(b1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            b2 = (BlockBorder)in.readObject();
            in.close();
        }
        catch (Exception e) {
            BlockBorderTests.fail((String)e.toString());
        }
        BlockBorderTests.assertTrue((boolean)b1.equals(b2));
    }
}

