/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.PeriodAxisLabelInfo;
import org.jfree.data.time.Day;
import org.jfree.data.time.Month;
import org.jfree.ui.RectangleInsets;

public class PeriodAxisLabelInfoTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(PeriodAxisLabelInfoTests.class);
    }

    public PeriodAxisLabelInfoTests(String name) {
        super(name);
    }

    public void testEquals() {
        PeriodAxisLabelInfo info1 = new PeriodAxisLabelInfo(Day.class, new SimpleDateFormat("d"));
        PeriodAxisLabelInfo info2 = new PeriodAxisLabelInfo(Day.class, new SimpleDateFormat("d"));
        PeriodAxisLabelInfoTests.assertTrue((boolean)info1.equals(info2));
        PeriodAxisLabelInfoTests.assertTrue((boolean)info2.equals(info1));
        Class c1 = Day.class;
        Class c2 = Month.class;
        SimpleDateFormat df1 = new SimpleDateFormat("d");
        SimpleDateFormat df2 = new SimpleDateFormat("MMM");
        RectangleInsets sp1 = new RectangleInsets(1.0, 1.0, 1.0, 1.0);
        RectangleInsets sp2 = new RectangleInsets(2.0, 2.0, 2.0, 2.0);
        Font lf1 = new Font("SansSerif", 0, 10);
        Font lf2 = new Font("SansSerif", 1, 9);
        Color lp1 = Color.black;
        Color lp2 = Color.blue;
        boolean b1 = true;
        boolean b2 = false;
        BasicStroke s1 = new BasicStroke(0.5f);
        BasicStroke s2 = new BasicStroke(0.25f);
        Color dp1 = Color.red;
        Color dp2 = Color.green;
        info1 = new PeriodAxisLabelInfo(c2, df1, sp1, lf1, lp1, b1, s1, dp1);
        info2 = new PeriodAxisLabelInfo(c1, df1, sp1, lf1, lp1, b1, s1, dp1);
        PeriodAxisLabelInfoTests.assertFalse((boolean)info1.equals(info2));
        info2 = new PeriodAxisLabelInfo(c2, df1, sp1, lf1, lp1, b1, s1, dp1);
        PeriodAxisLabelInfoTests.assertTrue((boolean)info1.equals(info2));
        info1 = new PeriodAxisLabelInfo(c2, df2, sp1, lf1, lp1, b1, s1, dp1);
        PeriodAxisLabelInfoTests.assertFalse((boolean)info1.equals(info2));
        info2 = new PeriodAxisLabelInfo(c2, df2, sp1, lf1, lp1, b1, s1, dp1);
        PeriodAxisLabelInfoTests.assertTrue((boolean)info1.equals(info2));
        info1 = new PeriodAxisLabelInfo(c2, df2, sp2, lf1, lp1, b1, s1, dp1);
        PeriodAxisLabelInfoTests.assertFalse((boolean)info1.equals(info2));
        info2 = new PeriodAxisLabelInfo(c2, df2, sp2, lf1, lp1, b1, s1, dp1);
        PeriodAxisLabelInfoTests.assertTrue((boolean)info1.equals(info2));
        info1 = new PeriodAxisLabelInfo(c2, df2, sp2, lf2, lp1, b1, s1, dp1);
        PeriodAxisLabelInfoTests.assertFalse((boolean)info1.equals(info2));
        info2 = new PeriodAxisLabelInfo(c2, df2, sp2, lf2, lp1, b1, s1, dp1);
        PeriodAxisLabelInfoTests.assertTrue((boolean)info1.equals(info2));
        info1 = new PeriodAxisLabelInfo(c2, df2, sp2, lf2, lp2, b1, s1, dp1);
        PeriodAxisLabelInfoTests.assertFalse((boolean)info1.equals(info2));
        info2 = new PeriodAxisLabelInfo(c2, df2, sp2, lf2, lp2, b1, s1, dp1);
        PeriodAxisLabelInfoTests.assertTrue((boolean)info1.equals(info2));
        info1 = new PeriodAxisLabelInfo(c2, df2, sp2, lf2, lp2, b2, s1, dp1);
        PeriodAxisLabelInfoTests.assertFalse((boolean)info1.equals(info2));
        info2 = new PeriodAxisLabelInfo(c2, df2, sp2, lf2, lp2, b2, s1, dp1);
        PeriodAxisLabelInfoTests.assertTrue((boolean)info1.equals(info2));
        info1 = new PeriodAxisLabelInfo(c2, df2, sp2, lf2, lp2, b2, s2, dp1);
        PeriodAxisLabelInfoTests.assertFalse((boolean)info1.equals(info2));
        info2 = new PeriodAxisLabelInfo(c2, df2, sp2, lf2, lp2, b2, s2, dp1);
        PeriodAxisLabelInfoTests.assertTrue((boolean)info1.equals(info2));
        info1 = new PeriodAxisLabelInfo(c2, df2, sp2, lf2, lp2, b2, s2, dp2);
        PeriodAxisLabelInfoTests.assertFalse((boolean)info1.equals(info2));
        info2 = new PeriodAxisLabelInfo(c2, df2, sp2, lf2, lp2, b2, s2, dp2);
        PeriodAxisLabelInfoTests.assertTrue((boolean)info1.equals(info2));
    }

    public void testHashCode() {
        PeriodAxisLabelInfo info1 = new PeriodAxisLabelInfo(Day.class, new SimpleDateFormat("d"));
        PeriodAxisLabelInfo info2 = new PeriodAxisLabelInfo(Day.class, new SimpleDateFormat("d"));
        PeriodAxisLabelInfoTests.assertTrue((boolean)info1.equals(info2));
        int h1 = info1.hashCode();
        int h2 = info2.hashCode();
        PeriodAxisLabelInfoTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        PeriodAxisLabelInfo info1 = new PeriodAxisLabelInfo(Day.class, new SimpleDateFormat("d"));
        PeriodAxisLabelInfo info2 = null;
        try {
            info2 = (PeriodAxisLabelInfo)info1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        PeriodAxisLabelInfoTests.assertTrue((info1 != info2 ? 1 : 0) != 0);
        PeriodAxisLabelInfoTests.assertTrue((info1.getClass() == info2.getClass() ? 1 : 0) != 0);
        PeriodAxisLabelInfoTests.assertTrue((boolean)info1.equals(info2));
    }

    public void testSerialization() {
        PeriodAxisLabelInfo info1 = new PeriodAxisLabelInfo(Day.class, new SimpleDateFormat("d"));
        PeriodAxisLabelInfo info2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(info1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            info2 = (PeriodAxisLabelInfo)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        boolean b = info1.equals(info2);
        PeriodAxisLabelInfoTests.assertTrue((boolean)b);
    }
}

