/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;

public class CategoryAxisTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CategoryAxisTests.class);
    }

    public CategoryAxisTests(String name) {
        super(name);
    }

    public void testEquals() {
        CategoryAxis a1 = new CategoryAxis("Test");
        CategoryAxis a2 = new CategoryAxis("Test");
        CategoryAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setLowerMargin(0.15);
        CategoryAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setLowerMargin(0.15);
        CategoryAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setUpperMargin(0.15);
        CategoryAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setUpperMargin(0.15);
        CategoryAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setCategoryMargin(0.15);
        CategoryAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setCategoryMargin(0.15);
        CategoryAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setMaximumCategoryLabelWidthRatio(0.98f);
        CategoryAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setMaximumCategoryLabelWidthRatio(0.98f);
        CategoryAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setCategoryLabelPositionOffset(11);
        CategoryAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setCategoryLabelPositionOffset(11);
        CategoryAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        CategoryAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        CategoryAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.addCategoryLabelToolTip((Comparable)((Object)"Test"), "Check");
        CategoryAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.addCategoryLabelToolTip((Comparable)((Object)"Test"), "Check");
        CategoryAxisTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testHashCode() {
        CategoryAxis a1 = new CategoryAxis("Test");
        CategoryAxis a2 = new CategoryAxis("Test");
        CategoryAxisTests.assertTrue((boolean)a1.equals(a2));
        int h1 = a1.hashCode();
        int h2 = a2.hashCode();
        CategoryAxisTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        CategoryAxis a1 = new CategoryAxis("Test");
        CategoryAxis a2 = null;
        try {
            a2 = (CategoryAxis)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        CategoryAxisTests.assertTrue((a1 != a2 ? 1 : 0) != 0);
        CategoryAxisTests.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        CategoryAxisTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testSerialization() {
        CategoryAxis a1 = new CategoryAxis("Test Axis");
        CategoryAxis a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (CategoryAxis)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        CategoryAxisTests.assertEquals((Object)a1, a2);
    }
}

